function x=rdisc(n,p)
% Given vector of probabilities p, rdisc(n,p) simulates n random indices

%% This works great for small problems
%%    x=1+sum( repmat(rand(n,1),1,length(p)) > repmat(cumsum(p),n,1), 2);

q=cumsum(p);
r=rand(1,n);
x=ones(1,n);
for i=1:length(q)
  x=x+(r>(q(i)*ones(1,n)));
end

