function gam = rgamma(alpha,beta)
% Generates random gamma deviates from density
%       beta^alpha g^alpha-1 exp(-beta*x)/Gamma(alpha)
%       E(gam) = alpha/beta   Var(gam)=a/beta^2
%
%  Begin by generating g~gamma(alpha,1)
%
  e = exp(1);
  gam = -ones(size(alpha));
  if alpha<1
     for i=1:length(alpha)
	g = -1; 
	a = alpha(i);
	aa = (a+e)/e;
	while g<0
	  r1 = rand;
	  r2 = rand;
	  if r1>1/aa
	     w = -log(aa*(1-r1)/a);
	     if r2 < w^(a-1)
		g = w;
	     end
	  else
	     w = (aa*r1)^(1/a);
	     if r2<exp(-w)
		g = w;
	     end
          end
        end
	gam(i) = g;
     end
  elseif alpha>1
     for i=1:length(alpha)
	a = alpha(i)-1;
	b = (alpha(i)-1/(6*alpha(i)))/a; 
	m = 2/a;
	d = m+2;
	g = -1;
	while g<0
	   x = rand;
	   y = rand;
	   v = b*y/x;
	   if (m*x-d+v+1/v) <= 0
		g = a*v;
	   elseif (m*log(x)-log(v)+v-1) <= 0
                g = a*v;
	   end
	end
	gam(i) = g;
      end
  else
	gam = -log(rand(size(alpha)));
  end
  gam = gam ./ beta;
	 
	
    	


