function[B,D,logpr] = riwB(r,n,Bs,Ds);
% Generates a single draw for the factor loading matrix B = the sqrt of a singular Wishart
%  given "previous" value Bs from the last set in MCMC
% Proposal distribution: V is W_m(n,S) with dimension m implicit
% where S =Bs. Bs' has rank r<n<m and Bs'Bs=Ds = diag and r by r
% note that E(V)=S/n in this notation (nb. may be non-singular of course) 
%
% Result gives B and D where V=B. B' and B'B=D diag
% Computation uses B=A.sqrt(D) and [A,D,F]=svd_mw(Bs.P') 
%     with P the upper triangular sqrt of sampled W = W_r(n,I)/n 
%
% There is a small detail to fix: I am sampling V and using MH ratio of
%  density p(V|S)/p(S|V)
% What I really want is p(B|Bs)/p(Bs|B) and these are not quite same 
%  -- a Jacobian element may be missing, to be finalised 
%
P=zeros(r);
sn=1/sqrt(n); 
for i=1:r
   P(i,i) = sqrt(gamrnd(((n-i+1)/2),2,1,1))*sn;
   P(i,(i+1):r) = randn(1,r-i)*sn;
end;

[A,D,F]=svd_mw(Bs*P');
%% B=abs(A*diag(D)).*sign(Bs); 
B=A*diag(D); 
D=(D.*D)'; 

% nb. if wanted, V = B*B';
%

% Now compute the unnormalised conditional density ratio p(B|Bs)/P(Bs|B) evaluated 
%  at the sampled value of B -- as follows, delivering the log of the ratio of 
%  priors in variable logpr
%  might need a factor of 0.5 in the coeff (m-1) here for Jacobian ...

 W=P'*P;  [m,a]=size(Bs); 
 logpr= ((m-1)*log(prod(D./Ds))-(trace(inv(W))-trace(W)))/2;
%
 

%% TEST EXAMPLE: MH sampling from the proposal, check acceptance rate
%  [a,d,f]=svd_mw(AD7129); r=5; a=a(:,1:r); d=d(1:r)'; 
%  Ds=d.*d; Bs=a*diag(d);
%  ac=[]; 
%  for i=1:5000
%     [B,D,logpr]=riwB(r,100,Bs,Ds); 
%     ac=[ac, rand(1)<=exp(logpr)];  
%  end;
%  sum(ac)/5000

%% Need to extend to include likelihood function ... 


