function [ pMem mMu mSig mDim ] = selapMix( dat,ss, unifBackground, fixedPrior )
% accepts a data set, dat, which consists of an NxP matrix where N is the
% number of observations from a space of dimension P.  These are assumed to
% originate from a mixture of normal distributions.  The number and prior
% means for the distributions are computed by affinity propogation.  Return
% values are: mem - NxK matrix of membership probabilities for each
% observation and each element in the mixture, mu - PxK dimensional matrix
% containing the posterior mean for the location of each of the K elements in the mixture, sigma -
% (PxP)xK matrix of covariance matricies.  Each column contains the
% elements in the covariance matrix for its corresponding mixture element.

if(nargin<4)
    fixedPrior=[];
end;
if(nargin<3)
    unifBackground=0;
end;

'Calculating similarities matrix.'
[N P]=size(dat);
S=zeros(N,N);
for(i=1:N)
    for(j=1:N)
        S(i,j)=-sum((dat(i,:)-dat(j,:)).^2);
    end;
end;

if(nargin==1)
    ss=median(S(:));
end;

'Computing affinity propogation clusters.'
idx=affProp(S,ss,.75);

['There are ' num2str(length(unique(idx))) ' groups.']

%%% hyper-parameters
df=P+1;
pSigma=(max(range(dat))/8)^2*eye(P);
kappa=3;

seeds=unique(idx);


%%% initialize
priorBg=.99;
pMu=[dat(seeds,:)' fixedPrior];
priorMu=[dat(seeds,:)' fixedPrior];
K=size(pMu,2);  
kSig=repmat(pSigma(:),1,K);
mem=zeros(size(idx));
for(i=1:length(seeds))
    mem(idx==seeds(i))=i;
end;
dimkp=ones(size(pMu));

'Fitting mixture distribution.'
iter=5000;
if(unifBackground)
    pMem=zeros(N,K+1);
else
    pMem=zeros(N,K);
end;
mMu=zeros(size(pMu));
mDim=zeros(size(dimkp));
mSig=zeros(size(kSig));
vdf=zeros(K,1);
for(i=1:iter)
    for(j=1:K)
        jdx=find(mem==j);
        nj=length(jdx);
        if(nj>0)
            z=dat(jdx,:)';
            mz=mean(z,2);
            z=z-repmat(mz,1,nj);
        end;
        sigma=pSigma;
        if(nj>0)
            sigma=sigma+z*z'+kappa*nj/(kappa+nj)*(mz-priorMu(:,j))*(mz-priorMu(:,j))';
        end;
        sigma=sigma*(kappa+nj+1)/((kappa+nj)*(df+nj-P+1));
        vdf(j)=df+nj-P+1;
        kSig(:,j)=sigma(:);

        pMu(:,j)=kappa/(kappa+nj)*priorMu(:,j);
        if(nj>0)
            pMu(:,j)=pMu(:,j)+nj/(kappa+nj)*mz;
        end;
%         sigma=mvNormalCov(pSigma,priorMu(:,j),df,kappa,z);
%         pMu(:,j)=mvNormalMean(priorMu(:,j),sigma,kappa,z);

%%% need to update dimension subset
%         dimkp(:,j)=mvtDimensionSubset(pMu,kSig,vdf,dat(jdx,:)');
        
        pMem(jdx,j)=pMem(jdx,j)+1;
        mSig(:,j)=mSig(:,j)+sigma(:);
        mMu(:,j)=mMu(:,j)+pMu(:,j);
        mDim(:,j)=mDim(:,j)+dimkp(:,j);
    end;
    mem=mvtMixtureMembership(pMu,kSig,vdf, [(1-priorBg)*ones(size(pMu,2),1)/size(pMu,2); priorBg], dat', dimkp, unifBackground);
    pMem(mem==size(mem,2),end)=pMem(mem==size(mem,2),end)+1;
    if(mod(i,100)==0)
        [num2str(i) '/' num2str(iter)]
    end;
end;
pMem=pMem/iter;
mSig=mSig/iter;
mMu=mMu/iter;
mDim=mDim/iter;
