function [ind,s]=select_genes_cor(X,Z,k)
% takes Nxn expression matrix x, outcome n vector z, and selects "top k"
%   based on correlation with outcome 
%

[N,n]=size(X); u=X-repmat(mean(X,2),1,n); y=reshape(Z,1,n)-mean(Z);  
v=sqrt(sum(u.*u,2).*sum(y.^2)); i=find(v>1e-15); s=zeros(N,1); 
s(i)=sum(u(i,:).*repmat(y,length(i),1),2)./v(i); 
[b,i]=sort(abs(s)); i=flipud(i); ind=i(1:k)'; 

clear i b y u v 