function [ y ] = standardize( x, dim )
%Standardize the columns of x.  If a second arguement is passed, it is
%interpreted as the dimension along which to standardize (2 to standardize
%the rows).

if(nargin==1)
    dim=1;
end;

if(dim==2)
    x=x';
end;

m=size(x,1);
y=x-repmat(mean(x),m,1);

v=std(y); i=find(v<=0); y(i,:)=0; v(i)=1; 
y=y./repmat(v,m,1);

if(dim==2)
    y=y';
end;