function [cent] = vennDiagram( a,b,c,ab,bc,ca )
%VENNDIAGRAM Summary of this function goes here
%   Detailed explanation goes here
mx=max([a,b,c,ab,bc,ca]);
a=a/mx;
b=b/mx;
c=c/mx;
ab=ab/mx;
bc=bc/mx;
ca=ca/mx;

ra=sqrt(a/3.1415);
rb=sqrt(b/3.1415);
rc=sqrt(c/3.1415);

x=[(-1:.01:1)*ra;(-1:.01:1)*rb;(-1:.01:1)*rc];
y=sqrt(repmat([ra;rb;rc].^2,1,201)-x.^2);

dab=findCircDist(ra,rb,ab);
dbc=findCircDist(rb,rc,bc);
dca=findCircDist(rc,ra,ca);

u=(dca^2-dbc^2+dab^2)/(2*dab);
v=sqrt(dca^2-u^2);
cent=[0,0;dab,0; u,v ];

clf;
hold on;
for(i=1:3)
    plot(x(i,:)+cent(i,1),y(i,:)+cent(i,2),'linewidth',2)
    plot(x(i,:)+cent(i,1),-y(i,:)+cent(i,2),'linewidth',2)
end;
set(gca,'XTick',[],'YTick',[]);
box on;
hold off;

