function [ ] = compareArraySignature( pth1, pth2, genes )
% Produces heatmaps of the same genes in two different datasets
% They will be ordered according to the first principal component
% of expression in the first dataset.  It assumes there are files
% called dataset.txt and probeids.txt in the directories passed as arguements.
% Pass path to dataset1, path to dataset2, genelist.

addpath c:\joe\utilities\;
curdir=pwd;
cd(pth1);
dat1=load('dataset.txt');
pid1=readWordlist('probeids.txt');

cd(pth2);
dat2=load('dataset.txt');
pid2=readWordlist('probeids.txt');

[a b c]=intersect(genes,pid1);
genes=genes(b);
pid1=pid1(c);
dat1=dat1(c,:);

[a b c]=intersect(genes,pid2);
genes=genes(b);
pid1=pid1(b);
dat1=dat1(b,:);
pid2=pid2(c);
dat2=dat2(c,:);

figure(1)
[oy ox]=imagepc(dat1,1,1,1);
figure(2)
[oy ox]=imagepc(dat2(oy,:),1,0,1);


