function controlfactors(nr,ny,nc,mPostPib,mA,mF,thr,Desig,showploty,labploty,pri);
% Identify significant genes in Affyx control factors and plot factors 
%
r0=ny; c0=1+nr;  nploty=size(showploty,2); 
for j=1:nc % Affyx control factors ... 
    i=find(mPostPib((r0+1):end,c0+j)>thr); ir=length(i);
    if (ir>0)
        q=mPostPib(r0+i,c0+j); m=q.*mA(r0+i,c0+j);
        [am,ai]=sort(abs(m),'descend'); 
        nai=min(30,length(ai));
        [ num2str( [ q(ai(1:nai)) m(ai(1:nai)) ] ) repmat('  ',nai,1) Desig(i(ai(1:nai)),:) ]   
    else
        fprintf('No significant genes at threshold 0.%i on latent factor %i\n',100*thr,j)
    end
    fprintf('Control factor: %i with %i significant genes \n',j,ir) 
   
    for i=1:nploty 
        figure(i); clf; ShowGeneX(mF,showploty(:,i),c0+j); 
        title(['Control factor ',int2str(j),' - Coded by ',labploty(i,:)])  
        xlabel('Samples');
        if (pri), eval(['print -dpng ctrlfactor.',int2str(j),'.y.',int2str(i),'.png']); end
    end
fprintf('Hit a key to see the next factor ....\n')
pause
end