function [ ig, Desig, nomatch ] = findgenes( Descriptors, probeids )
% finds gene descriptions from a dataframe descriptor
% probeids = cell array of probe IDs - the keys from a gene list textarray
% Descriptors = data frame of descriptions: lead in each row is key/probeid
%                  has p elements
% ig      = index in 1:p of the probeids
% Desig   = character array of selected descriptions
% nomatch = cell array of any non-matched probeids 
%
import dataframe.*; 
list=TextArray(char(probeids),'default'); 
list.setKeys(list.columnm(1));  % makes the probids the keys, instead of 1-k
m=list.merge0(Descriptors.toTextArray(true)); % match is based on keys 
nomatch = cellstr(char(m(4,:))); 
ig=Descriptors.getIndexm(m(1,:).keys);
Desig=char(Descriptors.getDesc);  
Desig=Desig(ig,:); 


%%% or, simply, but ignoring any possible non-matches:  
% ig=Descriptors.getIndexm(probeids);
% Desig=char(Descriptors.getDesc);  
% Desig=Desig(ig,:); 