function [ x probeids sampleids ] = getCorrected( pth )
%GETCORRECTED Summary of this function goes here
%   Detailed explanation goes here
cdir=pwd;
cd(pth);

rma=load('dataset.txt');
load H.txt;
load mA.txt;
load mPostPib.txt;

ids=fopen('probeids.txt','r');
c=textscan(ids,'%s');
probeids=c{1};
clear c;
fclose(ids);

ids=fopen('sampleids.txt','r');
c=textscan(ids,'%s');
sampleids=c{1};
clear c;
fclose(ids);


parms=fopen('parameters.txt','r');
done=0;
nd=0;
nc=0;
while(done<2)
    tline=fgets(parms);
    if(tline== -1)
        'ERROR: parameters.txt is missing either NDesignVariables or NControlVariables.'
        break;
    elseif(findstr('NControlVariables',tline)==1)
        tline(isspace(tline))=[];
        nc=nc+str2num(tline(19:end));
        done=done+1;
    elseif(findstr('NDesignVariables',tline)==1)
        tline(isspace(tline))=[];
        nd=nd+str2num(tline(18:end));
        done=done+1;
    end;
end;
fclose(parms);
    
i=[1 (nd+1):nc];
C=mA(:,i).*mPostPib(:,i);
x=rma-C*H(:,i)';

cd(cdir);