function [ af mPostPib probeids] = getFacScores( facPth, y, probeidsSmp )
%GETFACSCORES Summary of this function goes here
%   Detailed explanation goes here

cdir=pwd;
cd(facPth);

nSamp=size(y,2);
nAtom=parseParameters('NObservations');   %%% reads in nAtom, nCtrl and nDes
nDes=parseParameters('NDesignVariables');    %%% read in number of controls
nCtrl=parseParameters('NControlVariables');
useDp=parseParameters('NonGaussianFactors');

load mA.txt;
load mF.txt;
load mPostPib.txt;
load mPsi.txt;
load mAlpha.txt;
if(exist([facPth '\mVariablesIn.txt'],'file')>0)
    load mVariablesIn.txt;
end;
if(exist([facPth '\mExternalProb.txt'],'file')>0)
    load mExternalProb.txt;
end;


ids=fopen('probeids.txt','r');
c=textscan(ids,'%s');
probeids=c{1};
clear c;
fclose(ids);

if(exist([facPth '\mVariablesIn.txt'],'file')>0)
    pids=probeids(mVariablesIn);
else
    pids=probeids;
end;

[l ia ib]=intersect(probeidsSmp,pids);
% nFac=size(mA,1)-nCtrl;
fCol=(nDes+nCtrl+1):size(mA,2);
B=mA.*mPostPib;
B=B(ib,:);
mPsi=mPsi(ib);
k=inv(diag(ones([size(B,2) 1]))+B'*diag(1./mPsi)*B)*B'*diag(1./mPsi);
if(useDp)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% what to do with correction factors?
    x=y(ia,:)-B(:,1:(nCtrl+nDes))*k(1:(nCtrl+nDes),:)*y(ia,:);  % - impute lambdas
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    k=k(fCol,:);
    wts=zeros([nSamp nAtom+1]);
    wts(:,1)=logmvnpdf(x',zeros(1,length(ia)),B*B'+diag(mPsi))+log(mAlpha);
    fw=B(:,fCol)*mF(fCol,:);
    for(cwts=1:nAtom)
        wts(:,cwts+1)=logmvnpdf(x', fw(:,cwts)' ,diag(mPsi));
    end;
    wts=wts-repmat(max(wts,[],2),1,nAtom+1);
    wts=exp(wts);
    af=zeros(nSamp,length(fCol));
    for(i=1:nSamp)
        wts(i,:)=wts(i,:)/sum(wts(i,:));
        af(i,:)=wts(i,2:end)*mF((nDes+nCtrl+1):end,:)';
    end;
    af=af+(k*x)'.*repmat(wts(:,1),1,length(fCol));
else
%     af=(k*x)';
    af=(k*y(ia,:))';
    af=af(:,fCol);
end;

cd(cdir);

if(exist([facPth '\mVariablesIn.txt'],'file')>0)
    mPostPib=sortrows([mVariablesIn' mPostPib(:,fCol); mExternalProb]);
end;
mPostPib=mPostPib(:,2:end);

