function [data,rownames,colnames,projid] = read_dfm(dfmfile) 
% Reads data from a data frame text file
% 
% data is p.n variables by samples
% rownames is p.1 cell array of variable names  (eg: probeids or clinvar names)
% colnames is n.1 cell array of sample names (eg: sample ids)
% later: each of the above could be character arrays too
% 
% dfmfile is a character string for the filename
%
import dataframe.*;

%make sure there is an input dfm file name
if nargin ~= 1, error('This function needs one input argument'); end

if iscell(dfmfile), dfmfile = char(dfmfile); end 
if ~isstr(dfmfile), error('dfmfile must be a string'); end

%append extension if necessary
[pathstr, name, ext, versn] = fileparts(dfmfile);
if length(ext)<1, dfmfile = [dfmfile,'.dfm']; end

% Make sure file exists
if ~isequal(exist(dfmfile), 2), error('File not found.'); end

try 
    B=TextArray(dfmfile,1);
    if isempty(B.columns) error('format not recongized'); end 
    data=B.data;
    rownames=cellstr(char(B.keys));
    colnames=B.columnnames; projid=cellstr(char(colnames(1))); colnames=cellstr(char(colnames(2:end))); 
catch
    error('failed to use dataframe object'); end
end
