% read in several gene lists in order
founders=cell(0,1); othergenes=cell(0,1);

%% several ER and HER2 related genes 

founders(1,:)=cellstr('1893_s_at');   % ER
founders(2,:)=cellstr('33218_at');     % HER2
founders(3,:)=cellstr('160021_r_at');  % PR
%founders(1,:)=cellstr('40511_at');   % H-Gata3
%founders(2,:)=cellstr('36454_at');     % CA12 

%% 35 other ER and HER2 related genes 
geneids = TextArray('Gene.Lists/erher2.txt','default','na', 0);
geneids = geneids.keys;
othergenes((size(othergenes,1)+1):(size(othergenes,1)+size(geneids,1)),:)=geneids;


% some PR related ... 
geneids = TextArray('pr.txt','default','na', 0);
geneids = geneids.keys;
othergenes((size(othergenes,1)+1):(size(othergenes,1)+size(geneids,1)),:)=geneids;

%% 12 lists from evolfactoranal of Rb/E2F genes
for i=1:12
    geneids = TextArray(['Gene.Lists/e2f.g',int2str(i),'.txt'],'default','na', 0);
    geneids=geneids.keys;
    founders(size(founders,1)+1,:)=geneids(1);
    othergenes((size(othergenes,1)+1):(size(othergenes,1)+size(geneids,1)),:)=geneids(1:min(4,size(geneids,1)),:);
end

%% now run though the 9 oncogene lists, just use 10 or 25 (or whatever) each
%% DOESNT WORK - PROBEIDS DONT MATCH BECAUSE OF DIFFERENT CHIP.  THINK
%% AGAIN .... NEED MAPPED LISTS FROM ANDREA OR SOMETHING ELSE ....
%ng=10;
%for i=1:9
%    geneids = TextArray(['Gene.Lists/onco.g',int2str(i),'.txt'],'default','na', 0);
%    geneids=geneids.keys;
%    founders(size(founders,1)+1,:)=geneids(1);
%    geneids=geneids(1:25,:); 
%    othergenes((size(othergenes,1)+1):(size(othergenes,1)+size(geneids,1)),:)=geneids;
%end
 
%% make unique gene list 
othergenes=setxor(founders,unique(othergenes));
fprintf('%i founders and %i other genes\n',size(founders,1),size(othergenes,1))



% cleanup 
clear geneids 

