function responsefactors(nh,nresps,X,iin,iw,niw,mPostPib,mA,mu,thr,Desig,showploty,labploty,pri); 
% Identify significant genes in response factors, summarise and plot
% predictions and fitted values
%
nbinreg=nresps(1); nsurvreg=nresps(2); ncont=nresps(3); ncat=nresps(4); ny=sum(nresps); 
nf=size(mA,2)-nh-ny; jnf=(nh+ny)+(1:nf);
%
for j=1:ny % phenotype factors ... 
%
z=showploty(:,j); rfac=labploty(j,:); 
    %
    i=find(mPostPib((1+ny):end,nh+j)>thr); ir=length(i);
    if (ir>0)
        q=mPostPib(ny+i,nh+j); m=q.*mA(ny+i,nh+j);
        [am,ai]=sort(abs(m),'descend');   nai=min(30,length(ai));
            % could sort by q instead of m
        [ num2str( [ q(ai(1:nai)) m(ai(1:nai)) ] ) repmat('  ',nai,1) Desig(i(ai(1:nai)),:) ]   
       
    end
    fprintf('Response factor %i with %i significant genes at thr=0.%i\n',j,ir,100*thr) 
    i=find(mPostPib(j,jnf)>thr);
    if (length(i)>0),     fprintf('   ... and significant on factor %i\n',i);  end
    
            figure(3);   ShowGeneX(mu(:,iin),z(iin),j);  xlabel('Samples');  
                 title(['Fit/Predict \mu(',rfac,')'])
                 if (pri), eval(['print -dpng yfactor.mu.',int2str(j),'.png']); end
            figure(4);
            % binary responses ..
            if (j<=nbinreg), ShowGeneX(pnorm(mu(:,iin),0,1),z(iin),j);xlabel('Samples');
                title([rfac,': Fit/Predict Pr(',rfac,'+)']); axis([0 length(iin)+1 0 1]); 
                % base rate
                p0=sum(z==1)/sum(z==0|z==1); line([0 length(iin)+1],[p0 p0])
            end
            % continuous responses ..
            if (j>nbinreg+nsurvreg&j<=nbinreg+nsurvreg+ncont)
                scatter(mu(j,iin),X(j,iin)');xlabel('Fitted');ylabel(['Response ',int2str(j)])
                [c,pv]=corrcoef([mu(j,iin)' X(j,iin)']); pv=round(10000*pv(1,2))/10000;
                title(['Response ',int2str(j),': \rho=',num2str(c(1,2),2),',p=',num2str(pv,3)])
            end
   
            if (pri), eval(['print -dpng yfactor.prob.',int2str(j),'.png']); end
            %
       if (niw>0), 
            figure(1);   ShowGeneX(mu(:,iw),z(iw),j);xlabel('Samples');
                      title(['Test predict \mu(',rfac,')']); 
            if (pri), eval(['print -dpng yfactor.mu.pred.',int2str(j),'.png']); end
            figure(2); 
            % binary responses ..
            if (j<=nbinreg), ShowGeneX(pnorm(mu(:,iw),0,1),z(iw),j);xlabel('Samples');
                      title(['Test predict Pr(',rfac,'+)']); axis([0 niw+1 0 1]); line([0 niw+1],[p0 p0])
            end
            % continuous responses ..
            if (j>nbinreg+nsurvreg&j<=nbinreg+nsurvreg+ncont)
                scatter(mu(j,iw),X(j,iw)');xlabel('Predicted');ylabel(['Response ',int2str(j)])
                [c,pv]=corrcoef([mu(j,iw)' X(j,iw)']); pv=round(10000*pv(1,2))/10000;
                title(['Response ',int2str(j),': \rho=',num2str(c(1,2),2),',p=',num2str(pv,3)])
            end  
            if (pri), eval(['print -dpng yfactor.prob.pred.',int2str(j),'.png']); end
       end
    %    
if (j<ny), fprintf('\n \n \n \n Hit a key to see the next factor ....\n \n '); end
pause
end


