clear java;
root = '/home/jefftc/projects/genepattern/BFRM_normalize';
addpath([root '/Utilities']);
addpath([root '/bfrm.utilities.matlab']);
javaaddpath([root '/dataframe.jar']);
import dataframe.*;

NUM_CONTROL_FACTORS = 10;



%%% END OF PARAMETERS %%%


% Load the data set.
% Assume there's a file named 'dataset.txt'.
rma=load('dataset.txt');

% Find the AFFY control probes.
C=textscan(fopen('probeids.txt'), '%s');
pids = char(C{1});
i=find(all(pids(:,1:4)==repmat('AFFX',size(pids,1),1),2));
dopingCtrl=rma(i,:);
clear pids;

designHeader=['mean'];
   
H=ones(size(rma,2),1);

[a,d,f]=svd0(subtract_mean_rows(dopingCtrl));
nc=NUM_CONTROL_FACTORS;
H=[H f(1:nc,:)'];

%%%% Uncomment to just use regression with principal components of doping
%%%% controls to correct collection bias.
% for(i=1:size(rma,1))
%     rma(i,:)=rma(i,:)-regress(rma(i,:)',H)'*H';
% end;

[p n]=size(rma);
igenesin=double((1:p)'); 
% igenesin=find(abs(cr)>.4);
% igenesin=sort(b);
nh=size(H,2);               % number of design vectors
iw=[];                      % weights
nf=0;                       % number of latent factors
evolutionarySearch=0;
ny=0;                       % number of response variables
nbinreg=0;                  
nsurvreg=0;
ncont=0;
ncat=0;
nresps=[nbinreg nsurvreg ncont ncat];      
minpfac = 15;   % min number of genes in a factor
maxpin  = 25;   % max number of genes to pull in each step
maxf    = 20;   % max number of factors
maxp    = 1000;   % stop when reach the first of maxp genes or maxf factors 
nit=1000;      % number of burnin steps
nmc=10000;     % number of MCMC iterates 
missingResponse=0;
missingCovariates=0;
nonGaussianFactors=0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

save varin.txt igenesin -ASCII -TABS
save H.txt H -ASCII -TABS
save iw.txt iw -ASCII -TABS 

bfrm_setup
