function [  ] = bfrmNLF( datPth, dm, runDir)
%SETUPBFRM sets up BFRM for running outside of matlab.  Type should either
%be 'byprobe' or 'bykey'.

if(~exist(runDir,'dir'))
    'Run directory does not exist.  Creating it.'
    mkdir(runDir);
end;
if(runDir(end)~='\')
    'Adding \ to the end of the runDir path.'
    runDir=[runDir '\'];
end;

copyfile('d:\bfrm\bin\bfrm.exe',runDir);
copyfile('d:\bfrm\bin\bfrm64',runDir);

variables=[
        {'NObservations'};
        {'NVariables'};
        {'NBinaryResponses'};
        {'NCategoricalResponses'};
        {'NSurvivalResponses'};
        {'NContinuousResponses'};
        {'NDesignVariables'};
        {'NControlVariables'};
        {'NLatentFactors'};
        {'DataFile'};
        {'HFile'};
        {'#ResponseMaskFile'};
        {'#XMaskFile'};
        {'ShapeOfB'};
        {'NonGaussianFactors'};
        {'PriorPiStandard'};
        {'PriorPsia'};
        {'PriorPsib'};
        {'PriorSurvivalPsia'};
        {'PriorSurvivalPsib'};
        {'PriorRhoMean'};
        {'PriorRhoN'};
        {'PriorPiMean'};
        {'PriorPiN'};
        {'PriorTauDesigna'};
        {'PriorTauDesignb'};
        {'PriorTauResponseBinarya'};
        {'PriorTauResponseBinaryb'};
        {'PriorTauResponseCategoricala'};
        {'PriorTauResponseCategoricalb'};
        {'PriorTauResponseSurvivala'};
        {'PriorTauResponseSurvivalb'};
        {'PriorTauResponseContinuousa'};
        {'PriorTauResponseContinuousb'};
        {'PriorTauLatenta'};
        {'PriorTauLatentb'};
        {'PriorInterceptMean'};
        {'PriorSurvivalMean'};
        {'PriorContinuousMean'};
        {'PriorInterceptVar'};
        {'PriorSurvivalVar'};
        {'PriorContinuousVar'};
        {'Evol'};
        {'EvolVarIn'};
        {'EvolVarInFile'};
        {'EvolIncludeVariableThreshold'};
        {'EvolIncludeFactorThreshold'};
        {'EvolMiniumVariablesInFactor'};
        {'EvolMaximumFactors'};
        {'EvolMaximumVariables'};
        {'EvolMaximumVariablesPerIteration'};
        {'Burnin'};
        {'Burnin_Select'};
        {'nMCSamples'};
        {'nMCSamples_Select'};
        {'PrintIteration'};
        {'alpha'};
        {'alphaX'};
        {'PriorAlphaA'};
        {'PriorAlphaB'};
        {'InclusionMethod'};
        {'InverseWishart'};
        {'InverseWishartT0'}
    ];

defaults=[
        {''};
        {''};
        {'0'};
        {'0'};
        {'0'};
        {'0'};
        {'1'};
        {'0'};
        {'0'};
        {'dataset.txt'};
        {'H.txt'};
        {''};
        {''};
        {'2'};
        {'0'};
        {'1'};
        {'2'};
        {'0.005'};
        {'10'};
        {'2'};
        {'0.01'};
        {'30'};
        {'0.9'};
        {'10'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'8'};
        {'2'};
        {'0'};
        {'100'};
        {'1'};
        {'1'};
        {'1'};
        {''};
        {'varin.txt'};
        {'0.85'};
        {'0.85'};
        {'10'};
        {'40'};
        {''};
        {'20'};
        {'1000'};
        {'1000'};
        {'10000'};
        {'2000'};
        {'1000'};
        {'1'};
        {'0.01'};
        {'1'};
        {'1'};
        {'1'};
        {'0'};
        {'0'}
];

dfm=readDataframe(datPth,dm);

defaults(strcmp(variables,'NObservations'))=cellstr(num2str(size(dfm.xpr,2)));
defaults(strcmp(variables,'NVariables'))=cellstr(num2str(size(dfm.xpr,1)));
defaults(strcmp(variables,'Evol'))=cellstr(num2str(0));
defaults(strcmp(variables,'EvolVarIn'))=cellstr(num2str(size(dfm.xpr,2)));
defaults(strcmp(variables,'EvolMaximumVariables'))=cellstr(num2str(size(dfm.xpr,2)));

designHeader=cellstr('control');
   
H=ones(size(dfm.xpr,2),1);

[jnk ord]=sort(dfm.key(:,1));
dfm=reorderDFM(dfm,ord,'samples');

for(i=unique(dfm.key(:,1))')
    H=[H 1*strcmp(dfm.key(:,1),i)];
end;
designHeader=[designHeader; unique(dfm.key(:,1))];
for(i=2:length(dfm.keyHead))
    H=[H cell2mat(dfm.key(:,i))];
    designHeader=[designHeader; dfm.keyHead(i)];
end;
defaults(strcmp(variables,'NDesignVariables'))=cellstr(num2str(size(H,2)));

xpr=dfm.xpr;
igenesin=1:size(xpr,1);
save([runDir 'dataset.txt'],'xpr','-ASCII','-TABS');
% save([runDir 'xmask.txt'], 'xmask', '-ASCII', '-TABS');
save([runDir 'varin.txt'], 'igenesin', '-ASCII', '-TABS');
save([runDir 'H.txt'], 'H', '-ASCII', '-TABS');
%     save iw.txt iw -ASCII -TABS 
dlmwrite([runDir 'probeids.txt'],char(dfm.pids),'newline','pc','delimiter','');
dlmwrite([runDir 'sampleids.txt'],char(dfm.sids),'newline','pc','delimiter','');
dlmwrite([runDir 'des.txt'],char(designHeader),'newline','pc','delimiter','');
params=[char(variables) repmat(' = ',length(variables),1) char(defaults)];
dlmwrite([runDir 'parameters.txt'],params,'newline','pc','delimiter','');
end

