
model = Bfrm;
model.setData('../dataset.txt', p+ny, n);
if(~exist('nc'))
    'Warning: nc does not exist.  Setting to 0.'
    nc=0;
end;
model.setDesignControlFactors('H.txt', nh-nc, nc);
model.setResponseFactors(nbinreg,ncat,nsurvreg,ncont);
model.setLatentFactors(nf);
if(missingResponse)
    model.setResponseMask('ymask.txt');
end;
if(missingCovariates)
    model.setXMask('../xmask.txt') 
end;
model.setPriorInterceptMeanVar(8.0,100);        
    % for survival times:
    model.setPriorSurvivalMeanVar(2.0,1.0);  
    model.setPriorPsiSurvival(10.0, 2.0); 
    % model.setPriorContinuousMeanVar(0.0,1.0);   
model.setPriorPsi(2,0.005);    % Ga(a,b) prior for Psi_g
model.setPriorPi(0.9,10);       % beta prior for non-zero pi_{g,j}
model.setPriorRho(0.01, 30);  % beta prior for rho_j 
model.setPriorTauDesign(.5, .1);
model.setPriorTauResponse(.5,.1, .5,.1, .5,.1, .5,.1);
model.setPriorTauLatent(.5,.1);
model.setShapeOfB(2);
model.setNonGaussianFactors(nonGaussianFactors);     % 1=switch on DP model with config sampling
model.setPriorDPAlpha(1,1,1.0,.01); % prior for alpha Ga(1,1) in DP 
                                    % and inits for alpha=1.0, alphax=0.01
Tflag=0;t0=0; 
model.setWishart(Tflag, t0)
% default flag is set to 0, which deactivate the Wishart option. t0 is set
% to 1 by default.  
%model.setGPrior(Gpriorflag)      % 0 to switch off g-prior option, 1 to set it

model.setEvol(evolutionarySearch, length(igenesin), 'varin.txt');
model.setInclusionMethod(1)
%new parameters, obsolete Mu has been removed
%model.setEvolThresholds(IncludeVariableThreshold, IncludeFactorThreshold, 
%    MinimumNumberOfVariablesInFactor,MaximumNumberOfVariables, MaximumNumberOfFactors,
%    MaximumOfVariablesToBeAddedPerIteration);
model.setEvolThresholds(0.85,0.85,minpfac,maxp,maxf,maxpin);
model.setIterations(nit, nmc);
model.setDebug(1000);
model.save('parameters.txt');
thr=0.99; pri=0;
