function [ ] = compareArraySignature( samples, names, probeLists, reorderCols )
% Produces heatmaps of the same genes in two different datasets
% They will be ordered according to the first principal component
% of expression in the first dataset.  It assumes there are files
% called dataset.txt and probeids.txt in the directories passed as arguements.
% Pass path to dataset1, path to dataset2, genelist.

if(nargin<4)
    reorderCols=ones(length(samples),1);
end;

useProbes=[];
for(i=1:length(probeLists))
    useProbes=[useProbes; probeLists{i}];
end;
useProbes=unique(useProbes);

dat=[];
for(i=1:length(samples))
    tmp=importdata(char(samples{i}));
    pid=tmp.textdata(2:end,1);
    tmp=tmp.data;
    [a b c]=intersect(useProbes,pid);

    newDat=NaN*ones(length(useProbes),size(tmp,2));
    newDat(b,:)=tmp(c,:);
    dat=[dat {newDat}];
end;

for(i=1:length(probeLists))
    if(length(probeLists{i})>5)
        [a b c]=intersect(useProbes,probeLists{i});
        subplot(1,length(samples),1)
        [oy ox]=imagepc(dat{1}(b,:),reorderCols(1),1,1);
        set(gca,'fontsize',16,'linewidth',2)
        xlabel('Samples','fontsize',16)
        ylabel('Probe Sets','fontsize',16);
        title(char(names{1}),'fontsize',16);
        for(j=2:length(samples))
            subplot(1,length(samples),j);
            imagepc(dat{j}(b(oy),:),reorderCols(j),0,1);
            set(gca,'fontsize',16,'linewidth',2);
            xlabel('Samples','fontsize',16)
            ylabel('Probe Sets','fontsize',16);
            title(char(names{j}),'fontsize',16);
        end;
        savefig(['probeList' num2str(i)],'png');
    end;
end;


