function [ output_args ] = compareCGH( facPth, sigPth, desNum )
%COMPARECGH Compare a given set of factors to known CGH data

if(nargin<2)
    sigPth=[];
end;

if(facPth(end)~='\')
    facPth=[facPth '\'];
end;

if(length(sigPth)>0)
    if(sigPth(end)~='\')
        sigPth=[sigPth '\'];
    end;
end;

dataPth=[{'D:\dataRepository\tissueSamples\breast\gray\rma.txt'};
    {'D:\dataRepository\cellLines\gray\rma.txt.dfm'}];
cghPth=[{'D:\dataRepository\tissueSamples\breast\gray\20080306-tumorCgh.txt'};
    {'D:\dataRepository\cellLines\gray\20080306-cgh.txt'}];
names=[{'Tumor Samples'};
    {'Cell Lines'}];

minimum=[];
minLoc=[];
chrList=[];
kbList=[];
fac=[];
allmn=[];
cghList=[];
pList=[];

for(j=1:length(dataPth))
    ['computing factors: ' char(dataPth(j))]
    [tumorFac jnk tumorids] = getFacScores( facPth, char(dataPth(j)) );
    ['loading ' char(cghPth(j))]
    cghDat=importdata(char(cghPth(j)));
    [jnk ord]=sortrows(cghDat.data(:,1:2),[1 2]);
    cghDat.data=cghDat.data(ord,:);
    cghDat.textdata(2:end,:)=cghDat.textdata(ord+1,:);
    cghSids=cghDat.textdata(1,5:end)';
    cghIds=cghDat.textdata(2:end,1);
    chrList=[chrList {cghDat.data(:,1)}];
    cgh=cghDat.data(:,4:end);
    cghKb=cghDat.data(:,2);

    [a b c]=intersect(tumorids,cghSids);
    tumorFac=tumorFac(b,:);
    cgh=cgh(:,c)';
    clear cghSids;
    tumorids=tumorids(b);

    'computing factor-cgh correlations.'
    [r p]=corr(tumorFac,cgh,'type','kendall','rows','pairwise');
    [mn mnLoc]=min(p,[],2);
    allmn=[allmn mn];
    cghList=[cghList {cgh}];
    kbList=[kbList {cghKb}];
    fac=[fac {tumorFac}];
    minimum=[minimum {mn}];
    minLoc=[minLoc {mnLoc}];
    pList=[pList {p}];
end;
allmn=min(allmn,[],2);
mp=load([facPth 'mPostPib.txt']);
if(exist([facPth 'mExternalProb.txt'],'file'))
    mep=load([facPth 'mExternalProb.txt']);
    mvin=load([facPth 'mVariablesIn.txt']);
    mp=[[mvin' mp(:,2:end)]; mep];
    mp=sortrows(mp);
end;
xpr=load([facPth 'dataset.txt']);
nDrp=parseParameters('NControlVariables',facPth);
nDrp=nDrp+parseParameters('NDesignVariables',facPth);
mp=mp(:,(nDrp+1):end);
facPids=readWordlist([facPth 'probeids.txt']);
'Loading probe locations.'
loc=loadProbeLoc();

[a b c]=intersect(loc(:,1),facPids);
mp=mp(c,:);
facPids=facPids(c);
facLoc=loc(b,:);
[jnk ord]=sortrows(facLoc(:,2:3),[1 2]);
mp=mp(ord,:);
facLoc=facLoc(ord,:);

if(length(sigPth)>0)
    mpSig=load([sigPth 'mPostPib.txt']);
    maSig=load([sigPth 'mA.txt']);
    desSig=readWordlist([sigPth 'design.txt']);
    maSig=maSig(:,(1:length(desSig))+1);
    mpSig=mpSig(:,(1:length(desSig))+1);
    if(nargin>1)
        sigPids=readWordlist([sigPth 'probeids.txt']);
        [a b c]=intersect(loc(:,1),sigPids);
        mpSig=mpSig(c,:);
        maSig=maSig(c,:);
        sigLoc=loc(b,:);
        sigPids=sigPids(c);
        [jnk ord]=sortrows(sigLoc(:,2:3),[1 2]);
        mpSig=mpSig(ord,:);
        maSig=maSig(ord,:);
        sigLoc=sigLoc(ord,:);
        sigChr=cell2mat(sigLoc(:,2));
        sigKb=cell2mat(sigLoc(:,3));
        [a b c]=unique(sigChr);
        sigLoc=sigChr+sigKb./(sigKb(b(c))+100)-.5;
    end;
end;
for(i=1:size(tumorFac,2))
    if(nargin>1)
        writeme=zeros(length(sigPids),1);
    end;
%     if(allmn(i)<(.01/size(p,2)))
        clf;
        for(j=1:length(dataPth))
            cgh=cghList{j};
            mnLoc=minLoc{j};
            mn=minimum{j};
            tumorFac=fac{j};
            chr=chrList{j};
            cghKb=kbList{j};
            p=pList{j};
%             figure(2*j-1);
            subplot(length(dataPth)+1,4,(j-1)*4+1);
            plot(cgh(:,mnLoc(i)),tumorFac(:,i),'ok','markersize',10,'linewidth',3);
            set(gca,'fontsize',16);
            xlabel([char(cghIds(mnLoc(i))) ' ' num2str(chr(mnLoc(i))) '-' num2str(cghKb(mnLoc(i)))],'fontsize',16);
            ylabel(['Expression, factor ' num2str(i)],'fontsize',16);
            yl=ylim();
            xl=xlim();
            text(xl(1)*.9+xl(2)*.1,yl(1)*.1+yl(2)*.9,['p = ' num2str(mn(i))],'fontsize',16)
%             saveas(gcf,['factor' num2str(i) '-' char(names(j)) '-best.png']);
            
%             figure(2*j);
%             clf
            subplot(length(dataPth)+1,4,((j-1)*4+2):((j-1)*4+4))
            [a b c]=unique(chr);
            chrLoc=chr+cghKb./(cghKb(b(c))+100)-.5;
            hold on;
            even=find(mod(chr,2)==0);
            odd=find(mod(chr,2)==1);
            sig=find(p(i,:)<.01/size(p,2));
            sig5=find(p(i,:)>.01/size(p,2) & p(i,:)<.05/size(p,2));
            plot(chrLoc(even),-log(p(i,even)),'.k');
            plot(chrLoc(odd),-log(p(i,odd)),'.b');
            plot(chrLoc(sig),-log(p(i,sig)),'.r');
            plot(chrLoc(sig5),-log(p(i,sig5)),'.m');
            hold off;
            xlim([-.5 24.5]);
            title(char(names(j)),'fontsize',16);
%             hold on;
%             plot(find(chr==chr(mnLoc(i))),-log(p(i,chr==chr(mnLoc(i)))),'.r')
%             hold off;
%             [a b c]=unique(chr);
%             tmp=(b-[0; b(1:(end-1))])/2+[0; b(1:(end-1))];
%             tmp(22)=[];
%             tm=1:23;
%             tm(22)=[];
%             set(gca,'XTick',tmp,'XTickLabel',tm)
            set(gca,'XTick',1:23,'box','on');
            xlabel('Position in the Genome','fontsize',16)
            ylabel('-log(p-value) of correlation','fontsize',16)
            sigList=[char(cghIds(sig)) repmat(' ',length(sig),1) num2str(chr(sig)) repmat('-',length(sig),1) num2str(cghKb(sig))];
            dlmwrite(['factor' num2str(i) 'VS' char(names(j)) '-associations.txt'],sigList,'newline','pc','delimiter','');
        end;
        chr=cell2mat(facLoc(:,2));
        facKb=cell2mat(facLoc(:,3));
        [a b c]=unique(chr);
        chrLoc=chr+facKb./(facKb(b(c))+100)-.5;
        subplot(length(dataPth)+1,4,(length(dataPth)*4+2):(length(dataPth)*4+4))
        [fe xe]=ksdensity(chrLoc,'width',.1,'npoints',500);
        [f x u]=ksdensity(chrLoc,'weights',mp(:,i),'width',.1,'npoints',500);
        hold on;
        even=find(mod(round(x),2)==0);
        odd=find(mod(round(x),2)==1);
        rto=f./fe;
        plot(x(even),rto(even),'.k');
        plot(x(odd),rto(odd),'.b');
        col='grymcgrycm';
        if(nargin==2)
            for(desNum=1:length(desSig))
                kp=find(mpSig(:,desNum)>.99);
                for(cnt=1:length(kp))
                    if(rto(min(abs(sigLoc(kp(cnt))-x))==abs(sigLoc(kp(cnt))-x))>2.5)
                        plot(sigLoc(kp(cnt)),maSig(kp(cnt),desNum),'+','color',col(desNum));
                        writeme(kp(cnt))=1;
    %                     text(sigLoc(kp(cnt)),maSig(kp(cnt),desNum),char(sigPids(kp(cnt))),'color',col(desNum));
                    end;
                end;
            end;
        elseif(nargin==3)
            kp=find(mpSig(:,desNum)>.99);
            for(cnt=1:length(kp))
                if(rto(min(abs(sigLoc(kp(cnt))-x))==abs(sigLoc(kp(cnt))-x))>2.5)
                    plot(sigLoc(kp(cnt)),maSig(kp(cnt),desNum),'+','color',col(desNum));
                    writeme(kp(cnt))=1;
%                     text(sigLoc(kp(cnt)),maSig(kp(cnt),desNum),char(sigPids(kp(cnt))),'color',col(desNum));
                end;
            end;
        end;
        hold off;
        set(gca,'XTick',1:23,'box','on');
        xlabel('Position in the Genome','fontsize',16)
        ylabel('Gene Inclusion Density','fontsize',16)
        xlim([-.5 24.5]);
           
        subplot(length(dataPth)+1,4,length(dataPth)*4+1)
        set(gca,'fontsize',16,'box','on');
        imagepc(xpr(mp(:,i)>.99,:),1,1,1);
        if(nargin>1)
            writeme=find(writeme);
            dlmwrite(['signatureGenes' num2str(i) '.txt'],[char(sigPids(writeme)) repmat(' ',length(writeme),1) num2str(mpSig(writeme,:)) repmat(' ',length(writeme),1) num2str(maSig(writeme,:))],'delimiter','','newline','pc');
        end;
%         savefig(['factor' num2str(i)],'png');
%         pause;
%     end;
end;

