function [af Y sampleids] = getFacScores( facPth, y, probeidsSmp )
%GETFACSCORES Summary of this function goes here
%   Detailed explanation goes here

%if(facPth(end)~='\')
%    'Adding \ to the end of the path.'
%    facPth=[facPth '\'];
%end;

sampleids = NaN;
if(nargin==2)
    tmp=readDataframe(y);
    y=tmp.xpr;
    probeidsSmp=tmp.pids;
    sampleids=tmp.sids;
end;

load([facPth 'mA.txt']);
load([facPth 'mPostPib.txt']);
load([facPth 'mPsi.txt']);
if(exist([facPth 'mVariablesIn.txt'],'file')>0)
    load([facPth 'mVariablesIn.txt']);
end;

pids=readWordlist([facPth 'probeids.txt']);

if(exist([facPth 'mVariablesIn.txt'],'file')>0)
    pids=pids(mVariablesIn);
end;
clear mVariablesIn;

[jnk ord]=sort(pids);
pids=pids(ord); 
mPostPib=mPostPib(ord,:);
mA=mA(ord,:);
mPsi=mPsi(ord);

[l ia ib]=intersect(strtrim(probeidsSmp),pids);
Y=NaN*ones(length(pids),size(y,2));
Y(ib,:)=y(ia,:);
fitme=isnan(Y);

%%%%
drp=find(sum(isnan(Y),2)==size(Y,2));
mA(drp,:)=[];
mPostPib(drp,:)=[];
mPsi(drp)=[];
pids(drp)=[];
Y(drp,:)=[];
%%%%

for(i=1:size(Y,1))
    if(sum(isnan(Y(i,:)))==length(Y(i,:)))
        Y(i,:)=mA(i,1);
    else
        Y(i,isnan(Y(i,:)))=nanmean(Y(i,:));
    end;
end;

B=mA.*mPostPib;
mpi=repmat(mPsi',1,size(B,2));
M=inv(eye(size(B,2))+B'*(B./mpi))*(B./mpi)';

af=(M*Y)';



