function [af sampleids] = getFacScoresOld( facPth, y, probeidsSmp )
%GETFACSCORES Summary of this function goes here
%   Detailed explanation goes here

if(nargin==2)
    tmp=readDataframe(y);
    y=tmp.xpr;
    probeidsSmp=tmp.pids;
    sampleids=tmp.sids;
else
    sampleids=[];
end;

cdir=pwd;

cd(facPth);

% nSamp=size(y,2);
% nAtom=parseParameters('NObservations');   %%% reads in nAtom, nCtrl and nDes
% nDes=parseParameters('NDesignVariables');    %%% read in number of controls
% nCtrl=parseParameters('NControlVariables');
% useDp=parseParameters('NonGaussianFactors');

load mA.txt;
% load mF.txt;
load mPostPib.txt;
load mPsi.txt;
% load mAlpha.txt;
if(exist('mVariablesIn.txt','file')>0)
    load mVariablesIn.txt;
end;

pids=readWordlist('probeids.txt');

if(exist('\mVariablesIn.txt','file')>0)
    pids=pids(mVariablesIn);
end;
clear mVariablesIn;

[jnk ord]=sort(pids);
pids=pids(ord); 
mPostPib=mPostPib(ord,:);
mA=mA(ord,:);
mPsi=mPsi(ord);

[l ia ib]=intersect(strtrim(probeidsSmp),pids);
% nFac=size(mA,1)-nCtrl;
% fCol=(nDes+nCtrl+1):size(mA,2);
B=mA.*mPostPib;
B=B(ib,:);
mPsi=mPsi(ib);

for(i=1:size(y,1))
    y(i,isnan(y(i,:)))=nanmean(y(i,:));
end;
% y(isnan(y))=0;

mpi=repmat(mPsi',1,size(B,2));
af=(inv(eye(size(B,2))+B'*(B./mpi))*(B./mpi)'*y(ia,:))';
% k=inv(eye(size(B,2))+B'*(B./(mpi)))*B'./mpi';
% k=inv(eye(size(B,2))+B'*diag(1./mPsi)*B)*B'*diag(1./mPsi);
% useDp=0;
% if(useDp)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% what to do with correction factors?
%     x=y(ia,:)-B(:,1:(nCtrl+nDes))*k(1:(nCtrl+nDes),:)*y(ia,:);  % - impute lambdas
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     k=k(fCol,:);
%     wts=zeros([nSamp nAtom+1]);
%     wts(:,1)=logmvnpdf(x',zeros(1,length(ia)),B*B'+diag(mPsi))+log(mAlpha);
%     fw=B(:,fCol)*mF(fCol,:);
%     for(cwts=1:nAtom)
%         wts(:,cwts+1)=logmvnpdf(x', fw(:,cwts)' ,diag(mPsi));
%     end;
%     wts=wts-repmat(max(wts,[],2),1,nAtom+1);
%     wts=exp(wts);
%     af=zeros(nSamp,length(fCol));
%     for(i=1:nSamp)
%         wts(i,:)=wts(i,:)/sum(wts(i,:));
%         af(i,:)=wts(i,2:end)*mF((nDes+nCtrl+1):end,:)';
%     end;
%     af=af+(k*x)'.*repmat(wts(:,1),1,length(fCol));
% else
% %     af=(k*x)';
%     z=NaN*ones(size(k,2),size(y,2));
%     z(ib,:)=y(ia,:);
% %     tmp=y(ia,:);
%     z(isnan(z))=0;
%     af=(k*z)';
%     af=af(:,fCol);
% end;

cd(cdir);


