function [ dir probeids design] = getSignatures( path, posOnly )
%GETFACTORS Summary of this function goes here
%   Detailed explanation goes here
if(nargin<2)
    posOnly=0;
end;

cdir=pwd;
cd(path);
load mA.txt;
load mPostPib.txt;
load mPsi.txt;

parms=fopen('parameters.txt','r');
done=0;
nd=0;
while(done<1)
    tline=fgets(parms);
    if(tline== -1)
        'ERROR: parameters.txt is missing either NDesignVariables or NControlVariables.'
        break;
    elseif(findstr('NDesignVariables',tline)==1)
        tline(isspace(tline))=[];
        nd=nd+str2num(tline(18:end));
        done=done+1;
    end;
end;
fclose(parms);

%%% uncomment to keep only most differentially expressed %%%%%%%%
% for(i=2:nd)
%     drp=find(abs(mA(:,i))<quantile(abs(mA(:,i)),.99) | mPostPib(:,i)<.99);
%     mPostPib(drp,i)=0;
% end;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C=mA(:,2:nd).*mPostPib(:,2:nd);
dir=inv(eye(nd-1) + C'*(C./repmat(mPsi',1,nd-1)))*(C'./repmat(mPsi,nd-1,1));
dir=dir';
% dir=mA(:,2:nd).*mPostPib(:,2:nd)./repmat(sqrt(mPsi)',1,nd-1);
% dir=dir/norm(dir);

if(posOnly==1) dir(dir<0)=0; end;

ids=fopen('probeids.txt','r');
c=textscan(ids,'%s');
probeids=c{1};
clear c;
fclose(ids);

ids=fopen('design.txt','r');
c=textscan(ids,'%s');
design=c{1};
clear c;
fclose(ids);

cd(cdir);
