function imfacdecomp(x,probeids,mVariablesIn,finalig,nh,nr,nc,ny,nf,mPostPib,mA,mF,thr,Desig,sim,pri)

% Multi-factor image decomposition 
% sim=0 for images and sim=1 for surfc
% uses reorder_decomp to genes within factors "nicely" 

fi=2:size(mA,2); [n,p]=size(x);
B=mA((ny+1):end,fi); P=mPostPib((ny+1):end,fi); F=mF(fi,:);  
cfacindex=[repmat('r',1,nr),repmat('c',1,nc),repmat('y',1,ny),repmat('f',1,nf)];
ifacindex=[1:nr 1:nc 1:ny 1:nf];
xig=subtract_mean_rows(x(mVariablesIn,:)); gin=probeids(mVariablesIn);


%%%% now stuff from reorder_decomp
X=xig; [p,n]=size(X); I=(P>thr); des=Desig; [k,n]=size(F); A=B;

% sort factors 
%% [a,j]=sort(sum(I),'descend'); factord=j; 
%% B=B(:,j); A=B; P=P(:,j); I=I(:,j); B=A.*I; si=sum(I); F=F(j,:); 

B=A.*I; si=sum(I);

% then sort genes 
vin=[]; vout=(1:p)';  
for i=1:k
    ig=find(I(:,i));  [a,j]=sort(abs(B(ig,i)),'descend');
    vin=[vin;vout(ig(j))]; vout(ig)=[]; I(ig,:)=[]; B(ig,:)=[];
end
if (length(vout)>0)
    [a,j]=sort(max(P(vout,:)'),'descend');    vin=[vin;vout(j)]; 
end
A=A(vin,:); P=P(vin,:); des=des(vin,:); I=(P>thr);  B=A.*I;  X=X(vin,:);
%%%% end stuff from reorder_decomp

mi=min(min(xig)); ma=max(max(xig));  
figure(1); 
  if (sim==0), surfc(X); axis([0 n+1 0 finalig+1 mi ma])
  else, imagesc(X); axis([0 n+1 0 finalig+1]); end
cmap('jet'); 
title('Data'); xlabel('Samples'); ylabel('Genes')
if (pri), print -dpng imfdata.png; end

nff=size(B,2); imfac=zeros(nff,finalig,n); 
flab=[cfacindex' int2str(ifacindex')];
for j=1:nff
    imfac(j,:,:)=outer(B(:,j).*P(:,j).*(P(:,j)>thr),F(j,:),'*'); 
figure(2); 
  if (sim==0), surfc(squeeze(imfac(j,:,:))); axis([0 n+1 0 finalig+1 mi ma])
  else, imagesc(squeeze(imfac(j,:,:))); axis([0 n+1 0 finalig+1]); end
cmap('jet'); 
title(['Factor: ',flab(j,:)]); xlabel('Samples'); ylabel('Genes') 
if (pri), eval(['print -dpng imf.',flab(j,:),'.png']); end
pause
end
    



