function latentfactors(nh,ny,nf,mPostPib,mA,mF,thr,Desig,showploty,labploty,pri)
% Identify significant genes in factors, summarise and plot
%
c0=nh+ny;  nploty=size(showploty,2); 
for j=1:nf   
    i=find(mPostPib((ny+1):end,c0+j)>=thr); ir=length(i); 
    if (ir>0) 
         q=mPostPib(ny+i,c0+j); m=q.*abs(mA(ny+i,c0+j));
         [am,ai]=sort(m,'descend'); nai=min(50,length(ai)); % could sort by m instead of q
        [ num2str( [ q(ai(1:nai)) m(ai(1:nai)) ],2 ) repmat('  ',nai,1) Desig(i(ai(1:nai)),:) ]   
    else
        fprintf('No significant genes at threshold 0.%i on latent factor %i\n',100*thr,j)
    end    
    fprintf('Latent factor: %i with %i significant genes \n',j,ir) 
    for i=1:nploty 
        figure(i); clf; ShowGeneX(mF,showploty(:,i),c0+j); 
        title(['Latent factor ',int2str(j),' - Coded by ',labploty(i,:)])  
        xlabel('Samples');
        if (pri), eval(['print -dpng latentfactor.',int2str(j),'.png']); end
    end
fprintf('Hit a key to see the next factor ....\n')
pause
end
