function plotpredictDP(y,ex,ng2,ncont)
%   Plot contours of bivariate data and predictions for 2 genes 
%   from DP model 
%
% CALL:
%
%   ig2=[1 2]; ng2=['HER2';' ER '];  
%   plotpredictDP(y(ig2,:),ex(ig2,:),ng2)
%
 y=y'; 
 clf
 vX = linspace(min(y(:,1)),max(y(:,1)),12);
 vY = linspace(min(y(:,2)),max(y(:,2)),12);
 h=hist2d(y(:,[2 1]),vY,vX);
 vX=(vX(2:end)+vX(1:(end-1)))/2; vY=(vY(2:end)+vY(1:(end-1)))/2;
 contourf(vX,vY,h,ncont); % contour(vX,vY,h); 
 cmap('summer');  
 hold on; 
 scatter(ex(1,:),ex(2,:),'b+')
 hold off; 
 xlabel(ng2(1,:)); ylabel(ng2(2,:));
 %axis([min(ex(1,:)) max(ex(1,:)) min(ex(2,:)) max(ex(2,:))])