function badchips = quickqc (data,inorm,sthresh,ifig)
% quick and dirty review of array to array distributions...
%
% data   = p.n expression data array
% inorm  = 1(0) iff want to normalise to median same across chips
% sthres = threshold on abs chip correlation with median chip
% badchips = index vector of those lower than sthresh
% ifig = (optional) figure to plot correlations; default 1 
if (nargin<4), ifig=1; end
x=data; if inorm==1, x=normalise(x); end
[p,n]=size(x); 
m=median(x,2); [i,s]=select_genes_cor(x',m,n); 
figure(ifig); scatter(1:n,s)
badchips=find( s'<=sthresh);  
%
