function write_dfm(dfmfile,data,rownames,colnames)
% Writes data to a data frame text file
% 
% data is p.n variables by samples
% rownames is p.1 cell array of variable names
% colnames is n.1 cell array of sample names
% later: each of the above could be character arrays too
% 
% dfmfile is a character string for the filename
%
import dataframe.*;

%make sure there is an input dfm file name
if nargin < 2, error('This function needs at least two input arguments: a file name and a data matrix'); end
if nargin > 4, error('Too many input arguments are provided'); end

if iscell(dfmfile), dfmfile = char(dfmfile); end 
if ~isstr(dfmfile), error('dfmfile must be a string'); end
%append extension if necessary
[pathstr, name, ext, versn] = fileparts(dfmfile);
if length(ext)<1, dfmfile = [dfmfile,'.dfm']; end

if ~isa(data,'numeric'), error('data must be numeric'); end 
[p n] = size(data);

if nargin > 2 
    if isempty(rownames) 
        rownames=cellstr(int2str((1:p)'));
    else
        if ischar(rownames) 
            rownames = cellstr(rownames);
        end
        if ~iscell(rownames)
            error('rownames must be a char or cell array');
        end
        [p1 n1] = size(rownames);
        if p1 ~= p
            rownames = rownames';
        end
        [p1 n1] = size(rownames);
        if p1 ~= p
            error(['rownames must be a vector of length ',int2str(p)]);
        end
    end
else
    rownames=cellstr(int2str((1:p)'));
end

if nargin > 3 
    if isempty(colnames) 
        colnames=cellstr(int2str((1:n)'));
    else
        if ischar(colnames) 
            colnames = cellstr(colnames);
        end
        if ~iscell(colnames)
            error('colnames must be a char or cell array');
        end
        [p1 n1] = size(colnames);
        if p1 ~= n
            colnames = colnames';
        end
        [p1 n1] = size(colnames);
        if p1 ~= n
            error(['colnames must be a vector of length ',int2str(n)]);
        end
    end
else
    colnames=cellstr(int2str((1:n)'));
end
try 
    A=TextArray(data,colnames,rownames);
    A.save(dfmfile,1,1,1);
catch
    error('failed to use dataframe object'); end
end

