function [ output_args ] = projectLAHyp( facPth )
%PROJECTLAHYP Summary of this function goes here
%   Detailed explanation goes here

hypPth='D:\dataRepository\cellLines\lacticAcidosis_Hypoxia\rma.txt.dfm';
laPth='D:\dataRepository\cellLines\lactosis_acidosis\rma.txt.dfm';

tmp=importdata(hypPth);
probeidsSmp=tmp.textdata(2:end,1);
sampleids=tmp.textdata(1,2:end)';
y=tmp.data;
clear tmp;

af=getFacScores(facPth, y,probeidsSmp);

afRnd=zeros(length(af(:)),100);
for(i=1:100)
    tmp=getFacScores(facPth, y(randsample(size(y,1),size(y,1)),:),probeidsSmp);
    afRnd(:,i)=tmp(:);
    i
end;
afMn=zeros(size(af));
afMn(:)=mean(afRnd,2);
afSd=zeros(size(af));
afSd(:)=std(afRnd,[],2);

afTmp=(af-afMn)./afSd;

o=[1 1 1]';
clf;
% subplot(2,1,1);
% hold on;
% for(i=1:size(af,2))
%     mn=mean(af(1:3,i));
%     plot(i*o,af(1:3,i)-mn,'ok');
%     plot(i*o,af(4:6,i)-mn,'or');
%     plot(i*o,af(7:9,i)-mn,'ob');
%     plot(i*o,af(10:12,i)-mn,'og');
% end;
% hold off;
% 
subplot(2,1,1);
hold on;
for(i=1:size(af,2))
    mn=mean(afTmp(1:3,i));
    plot(i*o,afTmp(1:3,i)-mn,'ok');
    plot(i*o,afTmp(4:6,i)-mn,'or');
    plot(i*o,afTmp(7:9,i)-mn,'ob');
    plot(i*o,afTmp(10:12,i)-mn,'og');
end;
plot(xlim(),[norminv(.95,0,1) norminv(.95,0,1)],':','color',[.5 .5 .5])
plot(xlim(),[-norminv(.95,0,1) -norminv(.95,0,1)],':','color',[.5 .5 .5])
plot(xlim(),[norminv(.99,0,1) norminv(.99,0,1)],':k')
plot(xlim(),[-norminv(.99,0,1) -norminv(.99,0,1)],':k')
hold off;
set(gca,'fontsize',16,'linewidth',2,'box','on');
xlabel('Factors','fontsize',16);
ylabel('Standardized factor scores','fontsize',16);
legend([{'Control'};{'Lactic Acidosis'};{'Hypoxia'};{'Both'}],'location','NorthEastOutside')

tmp=importdata(laPth);
probeidsSmp=tmp.textdata(2:end,1);
sampleids=tmp.textdata(1,2:end)';
y=tmp.data;
clear tmp;

af=getFacScores(facPth, y,probeidsSmp);

afRnd=zeros(length(af(:)),100);
for(i=1:100)
    tmp=getFacScores(facPth, y(randsample(size(y,1),size(y,1)),:),probeidsSmp);
    afRnd(:,i)=tmp(:);
    i
end;
afMn=zeros(size(af));
afMn(:)=mean(afRnd,2);
afSd=zeros(size(af));
afSd(:)=std(afRnd,[],2);

afTmp=(af-afMn)./afSd;

o=[1 1 1 1 1 1]';
subplot(2,1,2);
hold on;
for(i=1:size(afTmp,2))
    mn=mean(afTmp(1:6,i));
    plot(i*o,afTmp(1:6,i)-mn,'ok');
    plot(i*o,afTmp(7:12,i)-mn,'oc');
    plot(i*o,afTmp(13:18,i)-mn,'om');
end;
plot(xlim(),[norminv(.95,0,1) norminv(.95,0,1)],':','color',[.5 .5 .5])
plot(xlim(),[-norminv(.95,0,1) -norminv(.95,0,1)],':','color',[.5 .5 .5])
plot(xlim(),[norminv(.99,0,1) norminv(.99,0,1)],':k')
plot(xlim(),[-norminv(.99,0,1) -norminv(.99,0,1)],':k')
hold off;
set(gca,'fontsize',16,'linewidth',2,'box','on')
xlabel('Factors','fontsize',16);
ylabel('Standardized factor scores','fontsize',16);
xlabel('Factors','fontsize',16);
ylabel('Standardized factor scores','fontsize',16);
legend([{'Control'};{'Lactosis'};{'Acidosis'}],'location','NorthEastOutside')

end

