function [ dfm ] = readDataframe( datPth, keyPth, facPth, annoPth )
%READDATAFRAME Import a dataframe object.

if(nargin<2)
    keyPth=[];
end;
if(nargin<3)
    facPth=[];
    mf=[];
end;
if(nargin<4)
    annoPth=[];
    annoHead=[];
    anno=[];
end;

missing='NaN';

p=linecount(datPth);

fid=fopen(datPth,'r');
head=fgets(fid);
nc=sum(strtrim(head)==9)+1;     %%%%%%% 9 is the tab character.
sids=cell(nc-1,1);
[jnk, remain]=strtok(head,9);
if(strcmp(jnk,'pids')~=1)
    'Top left of dataframe should contain "pids".'
    dfm=[];
    return;
end;
for(i=1:(nc-1))
    [sid remain]=strtok(remain,9);
    sids(i)=cellstr(sid);
end;

tmp=textscan(fid,['%s' repmat('%f',1,nc-1)],'CollectOutput',1);

fclose(fid);
dfm.sids=sids;
dfm.pids=tmp{1};
dfm.xpr=tmp{2};
[jnk ord]=sort(sids);
dfm.xpr=dfm.xpr(:,ord);
dfm.sids=dfm.sids(ord);
dfm.key=[];
dfm.keyHead=[];

if(length(keyPth)>0)
    key=scanfile(keyPth);
    dfm.keyHead=key(1,2:end)';
    key=key(2:end,:);
    k=cell(length(dfm.sids),size(key,2)-1);
    k(:)=cellstr('');
    [a b c]=intersect(key(:,1),dfm.sids);
    k(c,:)=key(b,2:end);
    numeric=zeros(1,size(k,2));
    for(i=1:size(k,2))
        if(length(c2n(k(:,i)))>0)
            numeric(i)=1;
            k(strcmp(k(:,i),''),i)=cellstr('NaN');
        end;
    end;
    [jnk ord]=sort(numeric);
    dfm.keyHead=dfm.keyHead(ord);
    k=k(:,ord);
    numeric=numeric(ord);
    for(i=find(numeric))
        k(:,i)=num2cell(c2n(k(:,i)));
    end;           
    dfm.key=k;
end;

if(length(annoPth)>0)
    anno=scanfile(annoPth);
    dfm.annoHead=anno(1,2:end);
    anno=anno(2:end,:);
    [a b c]=intersect(anno(:,1),dfm.pids);
    dfm.anno=anno(b,2:end);
    dfm.pids=dfm.pids(c,:);
    dfm.xpr=dfm.xpr(c,:);
end;

if(length(facPth)>0)
    if(facPth(end)~='\')
        facPth=[facPth '\'];
    end;
    mf=load([facPth 'mF.txt']);
    dfm.ma=load([facPth 'mA.txt']);
    dfm.mp=load([facPth 'mPostPib.txt']);
    dfm.mpsi=load([facPth 'mPsi.txt']);
    facPids=readWordlist([facPth 'probeids.txt']);
    if(exist([facPth 'mVariablesIn.txt'],'file'))
        vin=load([facPth 'mVariablesIn.txt']);
    else
        vin=1:size(dfm.ma,1);
    end;
    facPids=facPids(vin);
    [a b c]=intersect(dfm.pids,facPids);
    dfm.ma=dfm.ma(c,:);
    dfm.mp=dfm.mp(c,:);
    dfm.mpsi=dfm.mpsi(c);
    dfm.vin=b;
    fsids=readWordlist([facPth 'sampleids.txt']);
    [a b c]=intersect(fsids,dfm.sids);
    dfm.mf=mf(:,b)';
    dfm.sids=dfm.sids(c);
    dfm.xpr=dfm.xpr(:,c);
    dfm.key=dfm.key(c,:);
end;

end

