function [ dfm ] = reorderDFM( dfm, ord, dim )
%REORDERDFM reorders either the columns (dim='col') or rows (dim='row') dfm 

if(strcmp(dim,'row') | strcmp(dim,'probes'))
    dfm.pids=dfm.pids(ord);
    dfm.xpr=dfm.xpr(ord,:);
elseif(strcmp(dim,'col') | strcmp(dim,'samples'))
    dfm.sids=dfm.sids(ord);
    dfm.xpr=dfm.xpr(:,ord);
    if(length(dfm.keyHead)>0)
        dfm.key=dfm.key(ord,:);
    end;
else
    'The variable dim must be either "row" or "col".'
    return;
end;

end

