function [ output_args ] = setupBfrm( datPth, runDir, type, fl, corAP, design )
%SETUPBFRM sets up BFRM for running outside of matlab.  Type should either
%be 'byprobe' or 'bykey'.

if(nargin<6)
    design=[];
end;

if(nargin<5)
    corAP=1;
end;

if(~exist(runDir,'dir'))
    'Run directory does not exist.  Creating it.'
    mkdir(runDir);
end;
if(runDir(end)~='\')
    'Adding \ to the end of the runDir path.'
    runDir=[runDir '\'];
end;

copyfile('d:\bfrm\bin\bfrm.exe',runDir);
copyfile('d:\bfrm\bin\bfrm64',runDir);

variables=[
        {'NObservations'};
        {'NVariables'};
        {'NBinaryResponses'};
        {'NCategoricalResponses'};
        {'NSurvivalResponses'};
        {'NContinuousResponses'};
        {'NDesignVariables'};
        {'NControlVariables'};
        {'NLatentFactors'};
        {'DataFile'};
        {'HFile'};
        {'#ResponseMaskFile'};
        {'#XMaskFile'};
        {'ShapeOfB'};
        {'NonGaussianFactors'};
        {'PriorPiStandard'};
        {'PriorPsia'};
        {'PriorPsib'};
        {'PriorSurvivalPsia'};
        {'PriorSurvivalPsib'};
        {'PriorRhoMean'};
        {'PriorRhoN'};
        {'PriorPiMean'};
        {'PriorPiN'};
        {'PriorTauDesigna'};
        {'PriorTauDesignb'};
        {'PriorTauResponseBinarya'};
        {'PriorTauResponseBinaryb'};
        {'PriorTauResponseCategoricala'};
        {'PriorTauResponseCategoricalb'};
        {'PriorTauResponseSurvivala'};
        {'PriorTauResponseSurvivalb'};
        {'PriorTauResponseContinuousa'};
        {'PriorTauResponseContinuousb'};
        {'PriorTauLatenta'};
        {'PriorTauLatentb'};
        {'PriorInterceptMean'};
        {'PriorSurvivalMean'};
        {'PriorContinuousMean'};
        {'PriorInterceptVar'};
        {'PriorSurvivalVar'};
        {'PriorContinuousVar'};
        {'Evol'};
        {'EvolVarIn'};
        {'EvolVarInFile'};
        {'EvolIncludeVariableThreshold'};
        {'EvolIncludeFactorThreshold'};
        {'EvolMiniumVariablesInFactor'};
        {'EvolMaximumFactors'};
        {'EvolMaximumVariables'};
        {'EvolMaximumVariablesPerIteration'};
        {'Burnin'};
        {'Burnin_Select'};
        {'nMCSamples'};
        {'nMCSamples_Select'};
        {'PrintIteration'};
        {'alpha'};
        {'alphaX'};
        {'PriorAlphaA'};
        {'PriorAlphaB'};
        {'InclusionMethod'};
        {'InverseWishart'};
        {'InverseWishartT0'}
    ];

defaults=[
        {''};
        {''};
        {'0'};
        {'0'};
        {'0'};
        {'0'};
        {'1'};
        {'0'};
        {'0'};
        {'dataset.txt'};
        {'H.txt'};
        {''};
        {''};
        {'2'};
        {'0'};
        {'1'};
        {'2'};
        {'0.005'};
        {'10'};
        {'2'};
        {'0.01'};
        {'30'};
        {'0.9'};
        {'10'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'8'};
        {'2'};
        {'0'};
        {'100'};
        {'1'};
        {'1'};
        {'1'};
        {''};
        {'varin.txt'};
        {'0.85'};
        {'0.85'};
        {'10'};
        {'40'};
        {''};
        {'20'};
        {'1000'};
        {'1000'};
        {'10000'};
        {'2000'};
        {'1000'};
        {'1'};
        {'0.01'};
        {'1'};
        {'1'};
        {'1'};
        {'0'};
        {'0'}
];

tmp=importdata(datPth);
% probeids=cellstr(num2str(tmp.data(1:end,1)));
sampleids=tmp.textdata(1,2:end)';
if(size(tmp.data,2)==size(tmp.textdata,2))
    xpr=tmp.data(:,2:end);
    probeids=cellstr(num2str(tmp.data(2:end,1)));
else
    xpr=tmp.data;
    probeids=tmp.textdata(2:end,1);
end;
clear tmp;

defaults(strcmp(variables,'NObservations'))=cellstr(num2str(size(xpr,2)));
defaults(strcmp(variables,'NVariables'))=cellstr(num2str(size(xpr,1)));

if(strcmp(type,'byprobe'))
    useProbes=readWordlist(fl);
    [a igenesin c]=intersect(probeids, useProbes);
    len=length(igenesin);
elseif(strcmp(type,'bykey'))
    useProbes=importdata(fl);
    [a b c]=intersect(sampleids,useProbes.textdata(2:end,1));
    y=useProbes.data(c);
    binv=1:size(xpr,2);
    binv=binv(b);
    [jnk ord]=sort(binv);
    y=y(ord);
    pvs=zeros(size(xpr,1),1);
    for(i=1:length(pvs))
%         pvs(i)=kruskalwallis(xpr(i,:)',y,'off');
        pvs(i)=anovan(xpr(i,:)',y,'display','off');
    end;
    len=max(300,sum(pvs<.05/size(xpr,1)));
    [jnk kp]=sort(pvs);
    igenesin=sort(kp(1:len));
else
    'The variable "type" should be either "byprobe" or "bykey"'
    return;
end;

defaults(strcmp(variables,'EvolVarIn'))=cellstr(num2str(len));
mxin=max(500,2*len);
if(mxin>2000)
    mxin=max(2000,len);
end;  
defaults(strcmp(variables,'EvolMaximumVariables'))=cellstr(num2str(mxin));


designHeader=cellstr('control');
   
H=ones(size(xpr,2),1);
if(length(design)>0)
    tmp=importdata(design);
    [a b]=size(tmp.data);
    tmp.textdata((size(tmp.textdata,1)-a+1):end,(size(tmp.textdata,2)-b+1):end)=num2cell(tmp.data);
    grp=cell2mat(tmp.textdata(2:end,find(strcmp(tmp.textdata(1,:),'batchID'))));
    [a b c]=intersect(tmp.textdata(2:end,1),sampleids);
    sampleids=sampleids(c);
    xpr=xpr(:,c);
    grp=grp(b);
    for(i=unique(grp)')
        H=[H 1*(grp==i)];
    end;
    H(:,2)=[];
end;

if(corAP)
    %%%% put relevant genes at the top
    cdat=xpr(igenesin,:); xpr(igenesin,:)=[]; xpr=[cdat; xpr];
    tmp=probeids(igenesin); probeids(igenesin)=[]; probeids=[tmp; probeids];
    igenesin=1:len;
    cdat=xpr;
    %%%%%%%%%%%%%%%%
    %%% adjust for H if design is not empty
    if(length(design)>0)
        for(i=1:size(xpr,1))
            cdat=cdat(i,:)-regress(cdat(i,:)',H)'*H'
        end;
    end;
    %%%%%%%%%%%%%%%%%%%%%%
    S=abs(corr(cdat(igenesin,:)'));
    idx=affProp(S,-1,.9);
    uidx=unique(idx);
%     for(i=1:length(uidx)) imagepc(xpr(idx==uidx(i),:),0,1,1); pause; end;
    idxCnt=zeros(length(uidx),1);
    for(j=1:length(uidx))
        idxCnt(j)=sum(idx==uidx(j));
    end;
    [jnk ord]=sort(idxCnt,'descend');
    uidx=uidx(ord);
    tmp=probeids(uidx);
    probeids(uidx)=[];
    probeids=[tmp;probeids];
    tmp=xpr(uidx,:);
    xpr(uidx,:)=[];
    xpr=[tmp;xpr];
    defaults(strcmp(variables,'NLatentFactors'))=cellstr(num2str(length(uidx)));
end;

% xmask=1*(isnan(xpr));

% for(i=1:size(xpr,1))
%     xpr(i,isnan(xpr(i,:)))=nanmean(xpr(i,:));
% end;



save([runDir 'dataset.txt'],'xpr','-ASCII','-TABS');
% save([runDir 'xmask.txt'], 'xmask', '-ASCII', '-TABS');
save([runDir 'varin.txt'], 'igenesin', '-ASCII', '-TABS');
save([runDir 'H.txt'], 'H', '-ASCII', '-TABS');
%     save iw.txt iw -ASCII -TABS 
dlmwrite([runDir 'probeids.txt'],char(probeids),'newline','pc','delimiter','');
dlmwrite([runDir 'sampleids.txt'],char(sampleids),'newline','pc','delimiter','');
dlmwrite([runDir 'des.txt'],char(designHeader),'newline','pc','delimiter','');
params=[char(variables) repmat(' = ',length(variables),1) char(defaults)];
dlmwrite([runDir 'parameters.txt'],params,'newline','pc','delimiter','');
end

