function [ output_args ] = setupBfrmAll( dat, runDir, useProbes, changeV, val )
%SETUPBFRM sets up BFRM for running outside of matlab.  dat=data (create with 
%readDataFrame), runDir=path to the directory in which to set up BFRM,
%useProbes= cellstring containing the list of probes to use, changeV=
%cell containing strings with the names of the variable values to change,
%val=cell containing strings with the values to set the variables in
%changeV

corAP=1;

if(nargin<4)
    changeV=[];
    val=[];
end;

if(~exist(runDir,'dir'))
    'Run directory does not exist.  Creating it.'
    mkdir(runDir);
end;
if(runDir(end)~='\')
    'Adding \ to the end of the runDir path.'
    runDir=[runDir '\'];
end;

copyfile('d:\bfrm\bin\bfrm.exe',runDir);
copyfile('d:\bfrm\bin\bfrm64',runDir);

variables=[
        {'NObservations'};
        {'NVariables'};
        {'NBinaryResponses'};
        {'NCategoricalResponses'};
        {'NSurvivalResponses'};
        {'NContinuousResponses'};
        {'NDesignVariables'};
        {'NControlVariables'};
        {'NLatentFactors'};
        {'DataFile'};
        {'HFile'};
        {'#ResponseMaskFile'};
        {'#XMaskFile'};
        {'ShapeOfB'};
        {'NonGaussianFactors'};
        {'PriorPiStandard'};
        {'PriorPsia'};
        {'PriorPsib'};
        {'PriorSurvivalPsia'};
        {'PriorSurvivalPsib'};
        {'PriorRhoMean'};
        {'PriorRhoN'};
        {'PriorPiMean'};
        {'PriorPiN'};
        {'PriorTauDesigna'};
        {'PriorTauDesignb'};
        {'PriorTauResponseBinarya'};
        {'PriorTauResponseBinaryb'};
        {'PriorTauResponseCategoricala'};
        {'PriorTauResponseCategoricalb'};
        {'PriorTauResponseSurvivala'};
        {'PriorTauResponseSurvivalb'};
        {'PriorTauResponseContinuousa'};
        {'PriorTauResponseContinuousb'};
        {'PriorTauLatenta'};
        {'PriorTauLatentb'};
        {'PriorInterceptMean'};
        {'PriorSurvivalMean'};
        {'PriorContinuousMean'};
        {'PriorInterceptVar'};
        {'PriorSurvivalVar'};
        {'PriorContinuousVar'};
        {'Evol'};
        {'EvolVarIn'};
        {'EvolVarInFile'};
        {'EvolIncludeVariableThreshold'};
        {'EvolIncludeFactorThreshold'};
        {'EvolMiniumVariablesInFactor'};
        {'EvolMaximumFactors'};
        {'EvolMaximumVariables'};
        {'EvolMaximumVariablesPerIteration'};
        {'Burnin'};
        {'Burnin_Select'};
        {'nMCSamples'};
        {'nMCSamples_Select'};
        {'PrintIteration'};
        {'alpha'};
        {'alphaX'};
        {'PriorAlphaA'};
        {'PriorAlphaB'};
        {'InclusionMethod'};
        {'InverseWishart'};
        {'InverseWishartT0'}
    ];

defaults=[
        {''};
        {''};
        {'0'};
        {'0'};
        {'0'};
        {'0'};
        {'1'};
        {'0'};
        {'0'};
        {'dataset.txt'};
        {'H.txt'};
        {''};
        {''};
        {'2'};
        {'0'};
        {'1'};
        {'2'};
        {'0.005'};
        {'10'};
        {'2'};
        {'0.01'};
        {'30'};
        {'0.9'};
        {'10'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'0.5'};
        {'0.1'};
        {'8'};
        {'2'};
        {'0'};
        {'100'};
        {'1'};
        {'1'};
        {'0'};
        {''};
        {'varin.txt'};
        {'0.85'};
        {'0.85'};
        {'10'};
        {'50'};
        {''};
        {'20'};
        {'1000'};
        {'1000'};
        {'10000'};
        {'2000'};
        {'1000'};
        {'1'};
        {'0.01'};
        {'1'};
        {'1'};
        {'1'};
        {'0'};
        {'0'}
];

xpr=dat.xpr;
probeids=dat.pids;
sampleids=dat.sids;

%%% find and remove big outliers
outCount=sum(standardize(xpr,2)>3);
drp=find(outCount>.05*size(xpr,1));
if(length(drp)>0)
    ['Removing ' num2str(length(drp)) ' observations due to numerous outliers.']
    xpr(:,drp)=[];
    sampleids(drp)=[];
end;

if(sum(isnan(xpr(:)))>0)
    xmask=1*(isnan(xpr));
    for(i=1:size(xpr,1))
        xpr(i,isnan(xpr(i,:)))=nanmean(xpr(i,:));
    end;
    defaults(strcmp(variables,'#XMaskFile'))=cellstr('xmask.txt');
    variables(strcmp(variables,'#XMaskFile'))=cellstr('XMaskFile');
end;


defaults(strcmp(variables,'NObservations'))=cellstr(num2str(size(xpr,2)));
defaults(strcmp(variables,'NVariables'))=cellstr(num2str(size(xpr,1)));

igenesin=1:size(dat.xpr,1);
[a b c]=intersect(probeids, useProbes);
len=length(igenesin);

% defaults(strcmp(variables,'EvolVarIn'))=cellstr(num2str(len));
% mxin=max(500,2*len);
% if(mxin>2000)
%     mxin=max(2000,len);
% end;  
% defaults(strcmp(variables,'EvolMaximumVariables'))=cellstr(num2str(mxin));
defaults(strcmp(variables,'Evol'))=cellstr('0');


designHeader=cellstr('control');
   
H=ones(size(xpr,2),1);
% if(length(design)>0)
%     tmp=importdata(design);
%     [a b]=size(tmp.data);
%     tmp.textdata((size(tmp.textdata,1)-a+1):end,(size(tmp.textdata,2)-b+1):end)=num2cell(tmp.data);
%     grp=cell2mat(tmp.textdata(2:end,find(strcmp(tmp.textdata(1,:),'batchID'))));
%     [a b c]=intersect(tmp.textdata(2:end,1),sampleids);
%     sampleids=sampleids(c);
%     xpr=xpr(:,c);
%     grp=grp(b);
%     for(i=unique(grp)')
%         H=[H 1*(grp==i)];
%     end;
%     H(:,2)=[];
% end;

if(corAP)
    %%%% put relevant genes at the top
%     cdat=xpr(b,:); xpr(b,:)=[]; xpr=[cdat; xpr];
%     tmp=probeids(igenesin); probeids(igenesin)=[]; probeids=[tmp; probeids];
    cdat=xpr;
    %%%%%%%%%%%%%%%%
    %%% adjust for H if design is not empty
%     if(length(design)>0)
%         for(i=1:size(xpr,1))
%             cdat=cdat(i,:)-regress(cdat(i,:)',H)'*H'
%         end;
%     end;
    %%%%%%%%%%%%%%%%%%%%%%
    S=abs(corr(cdat(b,:)'));
    idx=affProp(S,-5,.9);
    uidx=unique(idx);
    uidx=b(uidx);
%     for(i=1:length(uidx)) imagepc(xpr(idx==uidx(i),:),0,1,1); pause; end;
    idxCnt=zeros(length(uidx),1);
    for(j=1:length(uidx))
        idxCnt(j)=sum(idx==uidx(j));
    end;
    [jnk ord]=sort(idxCnt,'descend');
    uidx=uidx(ord);
    tmp=probeids(uidx);
    probeids(uidx)=[];
    probeids=[tmp;probeids];
    tmp=xpr(uidx,:);
    xpr(uidx,:)=[];
    xpr=[tmp;xpr];
    defaults(strcmp(variables,'NLatentFactors'))=cellstr(num2str(length(uidx)));
    if(cell2mat(defaults(strcmp(variables,'EvolMaximumFactors')))<length(uidx))
        defaults(strcmp(variables,'EvolMaximumFactors'))=cellstr(num2str(length(uidx)));
    end;
end;

for(i=1:length(changeV))
    defaults(strcmp(variables,changeV(i)))=val(i);
end;

save([runDir 'dataset.txt'],'xpr','-ASCII','-TABS');
if(sum(strcmp(variables,'XMaskFile'))>0)
    save([runDir 'xmask.txt'], 'xmask', '-ASCII', '-TABS');
end;
save([runDir 'varin.txt'], 'igenesin', '-ASCII', '-TABS');
save([runDir 'H.txt'], 'H', '-ASCII', '-TABS');
%     save iw.txt iw -ASCII -TABS 
dlmwrite([runDir 'probeids.txt'],char(probeids),'newline','pc','delimiter','');
dlmwrite([runDir 'sampleids.txt'],char(sampleids),'newline','pc','delimiter','');
dlmwrite([runDir 'des.txt'],char(designHeader),'newline','pc','delimiter','');
params=[char(variables) repmat(' = ',length(variables),1) char(defaults)];
dlmwrite([runDir 'parameters.txt'],params,'newline','pc','delimiter','');
end

