function [  ] = setupBfrmXVal( dat, runDir, leaveOutGroups, phenotype, test, changeV, val )
%SETUPBFRMXVAL Summary of this function goes here
%   Detailed explanation goes here

if(nargin<=5)
    changeV=[];
    val=[];
end;

if(~exist(runDir,'dir'))
    'Run directory does not exist.  Creating it.'
    mkdir(runDir);
end;
if(runDir(end)~='\')
    'Adding \ to the end of the runDir path.'
    runDir=[runDir '\'];
end;

pt=find(strcmp(phenotype,dat.keyHead));
if(iscellstr(dat.key(:,pt)))
    [a b c]=unique(dat.key(:,pt));
else
    [a b c]=unique(cell2mat(dat.key(:,pt)));
end;
phenotype=a(c);

lg=find(strcmp(leaveOutGroups,dat.keyHead));
leaveOutGroups=dat.key(:,lg);


ulog=unique(leaveOutGroups);
pvs=zeros(size(dat.xpr,1),1);
for(i=1:length(ulog))
    if(isnumeric(leaveOutGroups))
        kp=find(leaveOutGroups~=ulog(i) & ~isnan(phenotype));
    else
        kp=find(strcmp(leaveOutGroups,ulog(i))==0 & ~isnan(phenotype));
    end;
    if(strcmp(test,'anovan'))
        for(j=1:size(dat.xpr,1))
            pvs(j)=anovan(dat.xpr(j,kp),phenotype(kp),'display','off');
        end;
    elseif(strcmp(test,'kruskalwallis'))
        for(j=1:size(dat.xpr,1))
            pvs(j)=kruskalwallis(dat.xpr(j,kp),phenotype(kp),'off');
        end;
    elseif(strcmp(test,'corr'))
        for(j=1:size(dat.xpr,1))
            [rho pvs(j)]=corr(dat.xpr(j,kp),phenotype,'rows','pairwise');
        end;
    else
        'Variable "test" must be "anovan", "kruskalwallis" or "corr"'
    end;
    if(sum(pvs<.01)>2500)
        [jnk ord]=sort(pvs);
        use=dat.pids(ord(1:2500));
    else
        use=dat.pids(pvs<.01);
    end;
    if(isnumeric(ulog))
        setupBfrmGenelist(dat,[runDir num2str(ulog(i))],use,changeV, val);
    else
        setupBfrmGenelist(dat,[runDir char(ulog(i))],use,changeV, val);
    end;
    i
end

