clear;
clear java;
javaaddpath 'l:\lucas\bfrm\Bin\dataframe.jar'
addpath l:\lucas\utilities;
addpath l:\lucas\bfrm\bfrm.utilities.matlab\;
import dataframe.*;
% function [  ] = setupRefinement( bfrmPth )
% %SETUPREFINEMENT bfrmPth - path to the output of a bfrm run.  The function will set
% %up a new BFRM run for each factor found in bfrmPth using the data in
% %tissuePth
% 
% oldLoc=pwd;
% cd(bfrmPth);
bPids=readWordlist('probeids.txt');
mp=load('mPostPib.txt');
nd=parseParameters('NDesignVariables');
nc=parseParameters('NControlVariables');
if(exist('mVariablesIn.txt','file'))
    load mVariablesIn.txt;
    load mExternalProb.txt;
    mp=[[mVariablesIn' mp(:,(nd+nc+1):end)];mExternalProb];
    mp=sortrows(mp);
    clear mVariablesIn mExternalProb;
end;
mp=mp(:,2:end);

%%% can potentially load different data here %%%
% cd(tissuePth)
load H.txt;
nc=parseParameters('NControlVariables');
load dataset.txt;
pids=readWordlist('probeids.txt');
rSids=readWordlist('sampleids.txt');
[a b c]=intersect(pids,bPids);
pids=pids(b);
dataset=dataset(b,:);
mp=mp(c,:);
if(exist('xmask.txt','file'))
    load xmask.txt;
    xmask=xmask(b,:);
end;
clear bPids a b c;

for(i=1:size(mp,2))
    kp=find(mp(:,i)>.99);
    if(length(kp)>2000)
        [jnk ord]=sort(mp(:,i),'descend');
        kp=find(mp(:,i)>=mp(ord(2000),i));
    end;
    rma=dataset(kp,:);
    fpids=pids(kp);
    if(exist('xmask','var'))
        xm=xmask(kp,:);
    end;
    
    cdat=subtract_mean_rows(rma);
    S=abs(corr(cdat'));
    idx=affProp(S,-2,.75);
    uidx=unique(idx);
%     length(uidx)
    idxCnt=zeros(length(uidx),1);
    for(j=1:length(uidx))
        idxCnt(j)=sum(idx==uidx(j));
    end;
    [jnk ord]=sort(idxCnt,'descend');
    uidx=uidx(ord);
    tmp=fpids(uidx);
    fpids(uidx)=[];
    fpids=[tmp;fpids];
    tmp=rma(uidx,:);
    rma(uidx,:)=[];
    rma=[tmp;rma];

    
    [p n]=size(rma);
    igenesin=double((1:p)'); 
    % igenesin=find(abs(cr)>.4);
    % igenesin=1:size(cdat,1);
    nh=size(H,2);               % number of design vectors
    iw=[];                      % weights
    nf=length(uidx);                       % number of latent factors
%     nf=0;
    evolutionarySearch=0;
    ny=0;                       % number of response variables
    nbinreg=0;                  
    nsurvreg=0;
    ncont=0;
    ncat=0;
    nresps=[nbinreg nsurvreg ncont ncat];      
    minpfac = 10;   % min number of genes in a factor
    maxpin  = 20;   % max number of genes to pull in each step
    maxf    = 30;   % max number of factors
    maxp    = p+1;   % stop when reach the first of maxp genes or maxf factors 
    nit=1000;      % number of burnin steps
    nmc=10000;     % number of MCMC iterates 
    missingResponse=0;
    missingCovariates=0;

    mkdir(['fac' num2str(i)]);
    cd(['fac' num2str(i)]);
    if(exist('xm','var'))
        missingCovariates=1;
        save xmask.txt xm -ASCII -TABS;
    end;
    nonGaussianFactors=0;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    save dataset.txt rma -ASCII -TABS
    save varin.txt igenesin -ASCII -TABS
    save H.txt H -ASCII -TABS
    dlmwrite('probeids.txt',char(fpids),'newline','pc','delimiter','');
    dlmwrite('sampleids.txt',char(rSids),'newline','pc','delimiter','');
    copyfile('l:\lucas\bfrm\bin\bfrm','.');
    copyfile('l:\lucas\bfrm\bin\bfrm.exe','.');

    bfrm_setup
    cd ..;
    i
end;
% cd(oldLoc);