#include "mex.h"
#include "string.h"
#include "assert.h"
#include "utilities.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    int N, n, *outputLengths, *backRefsTable, *extraReferences, *backRefsArray, *lastElementIndexTable, *levelIndexTable;
    char *fieldNames[] = {"N", "outputLengths", "table", "extraReferences", "array", "lastElementIndexTable"};
    
    /* Check for proper number of arguments */
    if (nrhs != 2 || nlhs > 1) {
        mexErrMsgTxt("Function takes two input and at most one output argument.");
    }

    /* TODO: add some data type checking */
    
    /* unpack input data pointers */
    N = (int) mxGetScalar(prhs[0]);
    n = (int) mxGetScalar(prhs[1]);

    plhs[0] = mxCreateStructMatrix(1, 1, 6, (const char **) fieldNames);
    
    /* have to compute output lengths first so we can allocate backRefsTable */
    mxSetField(plhs[0], 0, "outputLengths", mxCreateNumericMatrix(1, n, mxINT32_CLASS, mxREAL));
    outputLengths = (int *) mxGetData(mxGetField(plhs[0], 0, "outputLengths"));
    
    levelIndexTable = (int *) mxCalloc(N * n * N, sizeof(int));
    buildLevelIndexTable(levelIndexTable, outputLengths, N, n);
    
    mxSetField(plhs[0], 0, "N", mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL));
    *((int *) mxGetData(mxGetField(plhs[0], 0, "N"))) = N;
    mxSetField(plhs[0], 0, "table", mxCreateNumericMatrix(outputLengths[n - 2], n - 1, mxINT32_CLASS, mxREAL));
    backRefsTable = (int *) mxGetData(mxGetField(plhs[0], 0, "table"));
    mxSetField(plhs[0], 0, "extraReferences", mxCreateNumericMatrix(outputLengths[n - 1] - outputLengths[n - 2], 1, mxINT32_CLASS, mxREAL));
    extraReferences = (int *) mxGetData(mxGetField(plhs[0], 0, "extraReferences"));
    mxSetField(plhs[0], 0, "array", mxCreateNumericMatrix(outputLengths[n - 1], 1, mxINT32_CLASS, mxREAL));
    backRefsArray = (int *) mxGetData(mxGetField(plhs[0], 0, "array"));
    mxSetField(plhs[0], 0, "lastElementIndexTable", mxCreateNumericMatrix(N, n, mxINT32_CLASS, mxREAL));
    lastElementIndexTable = (int *) mxGetData(mxGetField(plhs[0], 0, "lastElementIndexTable"));
    
    buildBackReferenceTable(backRefsTable, extraReferences, backRefsArray, lastElementIndexTable, N, n, levelIndexTable, outputLengths);
    
    mxFree(levelIndexTable);
}
