#include "mex.h"
#include "string.h"
#include "assert.h"
#include "utilities.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    int N, n, dimensions[3], *levelIndexTable = NULL, *outputLengths = NULL;
    
    /* Check for proper number of arguments */
    if (nrhs != 2 || nlhs > 2) {
        mexErrMsgTxt("Function takes two input and at most two output arguments.");
    }

    /* TODO: add some data type checking */
    
    /* unpack input data pointers */
    N = (int) mxGetScalar(prhs[0]);
    n = (int) mxGetScalar(prhs[1]);
    
    /* allocate memory for outputs */
    dimensions[0] = dimensions[2] = N;
    dimensions[1] = n;
    plhs[0] = mxCreateNumericArray(3, dimensions, mxINT32_CLASS, mxREAL);
    levelIndexTable = (int *) mxGetData(plhs[0]);
    if (nlhs == 2) {
        plhs[1] = mxCreateNumericMatrix(1, n, mxINT32_CLASS, mxREAL);
        outputLengths = (int *) mxGetData(plhs[1]);
    }
    
    buildLevelIndexTable(levelIndexTable, outputLengths, N, n);
    
}
