/* This file contains header information for the computeHG class of 
 * functions, which are defined in the files "computeHGFromTable.c", and 
 * "computeHGFromLevelIndexTable.c".
 *
 * Written by Cy Chan, July 2007
 */

#ifndef computeHG_h
#define computeHG_h

#include "mex.h"

/* back reference table version */

double computeHGFromTable(double *bySize, double *x, double *y, double *a, 
                          double *b, int p, int q, int n, int N, 
                          int *outputLengths, int *backRefsTable, 
                          int tableStride, int *extraReferences, 
                          int *backRefsArray, int *lastElementIndexTable, 
                          int *add, double *mult, int *partitionSizesParam);
void computeCoefficientsFromTable(double *output, int *outputLengths, 
                                  double *a, double *b, int p, int q, 
                                  int n, int N, int *backRefsTable, 
                                  int tableStride, int *extraReferences, 
                                  int *add, double *mult, 
                                  int *partitionSizes, int numMatrixArgs);
void computeIdentitySchursFromTable(double *output, double c, 
                                    int outputLength, int n, int N, 
                                    int *backRefsTable, int tableStride, 
                                    int *extraReferences, 
                                    int *lastElementIndexTable);
void computeSchursFromTable(double *output, int *outputLengths, double *x, 
                            int n, int N, int *backRefsTable, 
                            int tableStride, int *backRefsArray, 
                            int *lastElementIndexTable);
void mulYFromTable(double *const output, int maxIndex, double x, int k, 
                   int *backRefsTable, int tableStride);

/* level index table version (lower memory requirements) */

double computeHGFromLevelIndexTable(double *bySize, double *x, double *y, 
                                    double *a, double *b, int p, int q, 
                                    int n, int N, int *levelIndexTable, 
                                    int stride1, int stride2);
void computeCoefficientsFromLevelIndexTable(double *output, 
                                            int outputLength, double *a, 
                                            double *b, int p, int q, int n,
                                            int N, int *levelIndexTable, 
                                            int stride1, int stride2,
                                            int *partitionSizes, int numMatrixArgs);
void computeIdentitySchursFromLevelIndexTable(double *output, double c, 
                                              int outputLength, int n, 
                                              int N, int *levelIndexTable, 
                                              int stride1, int stride2);
void computeSchursFromLevelIndexTable(double *output, int *outputLengths, 
                                      double *x, int n, int N, 
                                      int *levelIndexTable, int stride1, 
                                      int stride2);
void mulYFromLevelIndexTable(double *const output, int maxIndex, double x, 
                             int k, int n, int N, int *levelIndexTable, 
                             int stride1, int stride2, int *partition);

#endif /* computeHG_h */
