/* Written by Cy Chan, July 2007
 */

#include "mex.h"
#include "string.h"
#include "utilities.h"
#include "computeHG.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

    int i, p, q, n, N, *outputLengths = NULL, *backRefsTable = NULL, 
        tableStride, *extraReferences = NULL, *add = NULL, 
        *backRefsArray = NULL, *lastElementIndexTable = NULL, 
        *levelIndexTable = NULL, *partitionSizes = NULL, dim1, dim2, 
        numMatrixArgs;
    double *x = NULL, *y = NULL, *a = NULL, *b = NULL, *mult = NULL, 
           output, *hg = NULL;
    mxArray *mxArrayPointer = NULL, *coeffDataArrayPointer = NULL, 
            *coeffDataPointer = NULL;
    
    /* Check for proper number of arguments */
    if (nrhs < 5 || nrhs > 6 || nlhs > 2) {
        mexErrMsgTxt("Between five and six inputs and at most two output arguments expected");
    }

    /* TODO: add some data type checking.  Make sure struct has correct field names. */
    
    /* unpack input data pointers */
    x = mxGetPr(prhs[0]);
    n = mxGetNumberOfElements(prhs[0]);
    y = mxGetPr(prhs[1]);
    a = mxGetPr(prhs[2]);
    b = mxGetPr(prhs[3]);
    p = mxGetNumberOfElements(prhs[2]);
    q = mxGetNumberOfElements(prhs[3]);

    /* check to see if the second matrix argument is NaN, indicating we want the HG of a single matrix argument */
    if (mxGetNumberOfElements(prhs[1]) == 1 && mxIsNaN(*y)) {
        y = NULL;
        numMatrixArgs = 1;
    } else {
        if (mxGetNumberOfElements(prhs[1]) != n) {
            mexErrMsgTxt("dimension mismatch");
        }
        numMatrixArgs = 2;
    }
    

    if (mxGetClassID(prhs[4]) == mxSTRUCT_CLASS) {
        
        N = *((int *) mxGetData(mxGetField(prhs[4], 0, "N")));
        outputLengths = (int *) mxGetData(mxGetField(prhs[4], 0, "outputLengths"));
        if (n > mxGetDimensions(mxGetField(prhs[4], 0, "outputLengths"))[1]) {
            mexErrMsgTxt("n too large for back reference data");
        }
        backRefsTable = (int *) mxGetData(mxGetField(prhs[4], 0, "table"));
        tableStride = mxGetDimensions(mxGetField(prhs[4], 0, "table"))[0];
        backRefsArray = (int *) mxGetData(mxGetField(prhs[4], 0, "array"));
        lastElementIndexTable = (int *) mxGetData(mxGetField(prhs[4], 0, "lastElementIndexTable"));
        extraReferences = (int *) mxGetData(mxGetField(prhs[4], 0, "extraReferences"));
        
        if (numMatrixArgs == 1) {
            mxArrayPointer = mxGetField(prhs[4], 0, "coeffData1");
        } else {
            coeffDataArrayPointer = mxGetField(prhs[4], 0, "coeffData2");
            if (coeffDataArrayPointer) {
                for (i = 0; i < mxGetNumberOfElements(coeffDataArrayPointer); i++) {
                    coeffDataPointer = mxGetCell(coeffDataArrayPointer, i);
                    if (*((int *) mxGetData(mxGetField(coeffDataPointer, 0, "n"))) == n) {
                        mxArrayPointer = coeffDataPointer;
                    }
                }
            }
        }
        
        if (mxArrayPointer) {
            if (*((int *) mxGetData(mxGetField(mxArrayPointer, 0, "numMatrixArgs"))) != numMatrixArgs) {
                mexErrMsgTxt("invalid precomputed coeff data struct");
            }
            add = (int *) mxGetData(mxGetField(mxArrayPointer, 0, "add"));
            mult = mxGetPr(mxGetField(mxArrayPointer, 0, "mult"));
            mxArrayPointer = mxGetField(prhs[4], 0, "partitionSizes");
            if (mxArrayPointer) {
                partitionSizes = (int *) mxGetData(mxArrayPointer);
            }
        }

        if (nlhs == 2) {
            if (add && mult && !partitionSizes) {
                mexErrMsgTxt("Need partition sizes to break down result when using precomputed coefficient data");
            }
            plhs[1] = mxCreateDoubleMatrix(1, N + 1, mxREAL);
            hg = mxGetPr(plhs[1]);
        }

        output = computeHGFromTable(hg, x, y, a, b, p, q, n, N, outputLengths, backRefsTable, tableStride,
                                    extraReferences, backRefsArray, lastElementIndexTable, add, mult, partitionSizes);
        
    } else if (mxGetClassID(prhs[4]) == mxINT32_CLASS && mxGetNumberOfDimensions(prhs[4]) == 3) {

        if (nrhs != 6) {
            mexErrMsgTxt("Six inputs required for use with level index table");
        }
        
        dim1 = mxGetDimensions(prhs[4])[0];
        dim2 = mxGetDimensions(prhs[4])[1];
        N = mxGetScalar(prhs[5]);
        
        if (N > dim1) {
            mexErrMsgTxt("N too large for table");
        }
        if (n > dim2) {
            mexErrMsgTxt("n too large for table");
        }
        
        levelIndexTable = (int *) mxGetData(prhs[4]);
        if (nlhs == 2) {
            plhs[1] = mxCreateDoubleMatrix(1, N + 1, mxREAL);
            hg = mxGetPr(plhs[1]);
        }
        
        output = computeHGFromLevelIndexTable(hg, x, y, a, b, p, q, n, N, levelIndexTable, dim1, dim1 * dim2);
        
    } else {
        mexErrMsgTxt("Fifth parameter must be a back reference table or level index table");
    }
    
    plhs[0] = mxCreateDoubleScalar(output);
}
