computeHG('setMaxMem', 500 * 1024 * 1024);

fprintf('*** EXAMPLE 1 ***\n\n');

for (mode = 0:2)
    
    disp('Clearing persistent data ...');
    computeHG('clearData');
    fprintf('\n   Running test for mode = %d ... \n', mode);

    for (trial = 1:3)

        fprintf('\nRunning trial %d ... \n', trial);
        for (n = 5:7)

            N = 10 * n;
            p = 2;
            q = 2;
            a = randn(1, p);
            b = randn(1, q);
            x = randn(1, n);
            y = randn(1, n);

            fprintf('Computing N = %d, n = %d ...\n', N, n);

            tic;
            [result, byPartitionSize] = computeHG(mode, N, a, b, x, y);
            fprintf('computeHG time (mode %d): %g seconds\n', mode, toc);

        end

    end

    fprintf('\nMode %d used %d bytes of persistent memory\n\n', mode, computeHG('getCurMemInUse'));
    
end

fprintf('*** EXAMPLE 2 ***\n\n');

disp('Clearing persistent data ...');
computeHG('clearData');

for (trial = 1:3)
    
    fprintf('\n   Running trial %d ...\n\n', trial);
    for (n = 30:5:45)

        N = n;
        p = 2;
        q = 2;
        a = randn(1, p);
        b = randn(1, q);
        x = randn(1, n);
        y = randn(1, n);

        fprintf('Computing N = %d, n = %d ...\n', N, n);

        tic;
        [result, byPartitionSize] = computeHG(2, N, a, b, x, y);
        fprintf('computeHG time (mode 2): %g seconds\n', toc);
        
        figure(2); plot(log10(abs(byPartitionSize / result)));
        title('Relative log of partial sums');
        figure(1); plot(cumsum(byPartitionSize));
        title('Convergence of function by partition size (pausing 1 second...)');
        
        pause(1);

    end

end

fprintf('\nUsed %d bytes of persistent memory\n\n', computeHG('getCurMemInUse'));
