/* Written by Cy Chan, July 2007
 */

#include "mex.h"
#include "string.h"
#include "utilities.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

    int n, N, outputLength, numMatrixArgs, *add = NULL, *partitionSizes = NULL;
    double *mult = NULL;
    const char *fields[] = {"n", "numMatrixArgs", "add", "mult"};
    
    /* Check for proper number of arguments */
    if (nrhs != 4) {
        mexErrMsgTxt("Four inputs required.");
    } else if (nlhs > 2) {
        mexErrMsgTxt("Too many output arguments");
    }

    /* TODO: add some data type checking */
    
    /* unpack input data pointers */
    N = mxGetScalar(prhs[0]);
    n = mxGetScalar(prhs[1]);
    outputLength = mxGetScalar(prhs[2]);
    numMatrixArgs = mxGetScalar(prhs[3]);

    /* set up outputs */
    plhs[0] = mxCreateStructMatrix(1, 1, 4, fields);
    mxSetField(plhs[0], 0, "n", mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL));
    *((int *) mxGetData(mxGetField(plhs[0], 0, "n"))) = n;
    mxSetField(plhs[0], 0, "numMatrixArgs", mxCreateNumericMatrix(1, 1, mxINT32_CLASS, mxREAL));
    *((int *) mxGetData(mxGetField(plhs[0], 0, "numMatrixArgs"))) = numMatrixArgs;
    mxSetField(plhs[0], 0, "add", mxCreateNumericMatrix(outputLength, 1, mxINT32_CLASS, mxREAL));
    add = (int *) mxGetData(mxGetField(plhs[0], 0, "add"));
    mxSetField(plhs[0], 0, "mult", mxCreateDoubleMatrix(outputLength, 1, mxREAL));
    mult = mxGetPr(mxGetField(plhs[0], 0, "mult"));
    
    plhs[1] = mxCreateNumericMatrix(outputLength, 1, mxINT32_CLASS, mxREAL);
    partitionSizes = (int *) mxGetData(plhs[1]);
    
    precomputeCoeffData(add, mult, partitionSizes, outputLength, n, N, numMatrixArgs);

}
