/* Written by Cy Chan, July 2007
 */

#ifndef utilities_h
#define utilities_h

#include "mex.h"

double updateQ(double Q, double *a, double *b, int p, int q, int n,
               int *partition, int partitionLength, int elementDecremented, 
               int add, double mult, int numberOfMatrixArgs);
void precomputeCoeffData(int *add, double *mult, int *partitionSizes, 
                         int outputLength, int n, int N, 
                         int numberOfMatrixArgs);
void computeCoefficientData(int *add, double *mult, int *partition, int n,
                            int partitionlength, int elementDecremented, 
                            int numberOfMatrixArgs);

void buildBackReferenceTable(int *backRefsTable, int *extraReferences, 
                             int *backRefsArray, 
                             int *lastElementIndexTable, int N, int n, 
                             int *levelIndexTable, int *outputLengths);
int computeBackReference(int mode, int *partition, int partitionSize, 
                         int curIndex, int k, int N, int *levelIndexTable, 
                         int stride1, int stride2);
bool iteratePartition(int *const partition, int *const partitionSize, 
                      int *const partitionLength, const int N, const int n);

void buildLevelIndexTable(int *levelIndexTable, int *outputLengths, int maxN, int maxn);
void buildPhiTable(int *phi, int maxN, int maxn);

void computeOutputLengths(int *outputLengths, int *levelIndexTable, int stride1, int stride2, int n, int N);

void mexPrintArray(const int *const array, const int length);
void mexPrintDoubleArray(const double *const array, const int length);

#endif /* utilities_h */
