function bcpairstv(F,Z,itr,ival,ind)
%  Pairwise scatterplots of arrays on Metagenes in F
%  Columns are arrays, rows are factors 
%  with numbers and coloured according to one of two groups in indicator Z
%  which can be 0,1 or something else (=unclassified) 
% Version that plots training and validation samples in different colours
% 
clf;
if (length(ival)==0) 
	bcpairs(F,Z,ind);
	return
end

[p n]=size(F);n=length(ind); 
a=min(F(ind,:)'); b=max(F(ind,:)'); del=(b-a)/8; a=a-del; b=b+del;

nnt=itr;  n0t=nnt(Z(itr)==0);  n1t=nnt(Z(itr)==1);  n2t=nnt(~(Z(itr)==1|Z(itr)==0));
nnv=ival; n0v=nnv(Z(ival)==0); n1v=nnv(Z(ival)==1); n2v=nnv(~(Z(ival)==1|Z(ival)==0));


pic=1;
for i=1:(n-1)
  for j=(i+1):n
    subplot(n-1,n-1,pic)
    set(gca,'fontsize',12)
    axis([a(j) b(j) a(i) b(i)]);
    hold on; 
    plot([a(j) b(j)],[0 0],'k:');
    plot([0 0],[a(i) b(i)],'k:');
    xlabel(['Metagene ',int2str(ind(j))]);  ylabel(['Metagene ',int2str(ind(i))]);
 % training cases 
    for h=n1t
      text(F(ind(j),h),F(ind(i),h),int2str(h),'Color','r','HorizontalAlignment','Center','fontsize',11)
    end;
    for h=n0t
      text(F(ind(j),h),F(ind(i),h),int2str(h),'Color','b','HorizontalAlignment','Center','fontsize',11)
    end;
    for h=n2t
      text(F(ind(j),h),F(ind(i),h),int2str(h),'Color','k','HorizontalAlignment','Center','fontsize',11)
    end;
 % validation cases 
    for h=n1v
      text(F(ind(j),h),F(ind(i),h),int2str(h),'Color','m','HorizontalAlignment','Center','fontsize',11)
    end;
    for h=n0v
      text(F(ind(j),h),F(ind(i),h),int2str(h),'Color','c','HorizontalAlignment','Center','fontsize',11)
    end;
    for h=n2v
      text(F(ind(j),h),F(ind(i),h),int2str(h),'Color','k','HorizontalAlignment','Center','fontsize',11)
    end;
    hold off;
    pic=pic+1;
  end;
  pic=pic+i;
end;
hold off;
% 

