function [B,F] = ltriangfactor(b,f);

% input a factor analysis X=bf (such as b=adf from svd) and outputs
% a lower triangular, Aguilar/West factor form X=BF
B=b; [N,n]=size(B); 
for j=1:n
 % reorder rows by abs loading on factor j, then
 %    make j-th row of B look like [0,...,0,1,0,...,0]
  nj=j:n; Nj=j:N; 
  [a,i]=sort(abs(B(Nj,j))); i=flipud(i); % X(Nj,:)=X(Nj(i),:); des(Nj,:)=des(Nj(i),:); 
  B(Nj,:)=B(Nj(i),:); 
  P=eye(n); P(j,nj)=-B(j,nj)/B(j,j); P(j,j)=1/B(j,j); B=B*P; F=P\f; 
end;


