function [o2 o1 sortVec pv] = imagepc( z, group, highContrast,reordRow )
%IMAGEPC Summary of this function goes here
%   Detailed explanation goes here
reordCol=1;
if(nargin<3)
    highContrast=0;
end;
if(nargin<4)
    reordRow=1;
end;

if(sum(isnan(z(:)))>0)
    nanset=isnan(z);
    hasnan=1;
%     for(i=1:size(z,1))
%         kp=find(~isnan(z(i,:)));
%         z(i,kp)=z(i,kp)-mean(z(i,kp));
%         if(length(kp)>1) 
% %             z(i,kp)=z(i,kp)/std(z(i,kp));
%             z(i,kp)=standardize(z(i,kp),2);
%         end;
%     end;
    z=standardize(z,2);
    z(find(nanset))=0;
    mn=find(min(z')'==0);
    mx=find(max(z')'==0);
    drp=intersect(mn,mx);
    kp=1:size(z,1);
    kp(drp)=[];
%     z(drp,:)=[];
%     nanset(drp,:)=[];
else
    hasnan=0;
%     z=z-repmat(mean(z,2),1,size(z,2));
%     z=z./repmat(std(z')',1,size(z,2));
    z=standardize(z,2);
    kp=1:size(z,1);
end;

[a,d,f]=svd0(z(kp,:));
sortVec=f(1,:)';

[jnk o1]=sort(group);

scrs=z*sortVec;
if(reordRow)
%     scrs=z*f(1,:)';
    [jnk o2]=sort(scrs);
else
    o2=1:size(z,1);
%     b=regress(scrs,[ones(size(scrs)) (1:size(scrs,1))']);
%     if(b(2)<0)
%         o1=o1(end:-1:1);
%         sortVec=-sortVec;
%         scrs=-scrs;
%     end;
end;

pv=binocdf(sum(scrs(2:end)<scrs(1:(end-1))),length(scrs)-1,.5);

if(hasnan)
    z(nanset)=NaN;
    kr=jet;
    kr(1,:)=[1 1 1];
    colormap(kr);
end;

if(~highContrast)
    imagesc(z(o2,o1))
else
    imagesc(abs(z(o2,o1)).^(1/3).*sign(z(o2,o1)));
%     imagesc(z(o2,o1).^(1/3));
end;
group=group(o1);
[ugrp b c]=unique(group);
hold on;
for(i=1:(length(ugrp)-1))
    plot([b(i)+.5 b(i)+.5],ylim(),'w','linewidth',3);
end;
hold off;
xt=(b+[0; b(1:(end-1))+1])/2;
set(gca,'fontsize',16,'box','on','linewidth',2,'XTick',xt,'XTickLabel',ugrp);
