function [ mu sigma lp ll] = lMix( y, id, w )
%LMIX accepts a p x d matrix and a p x 1 vector of group id's, where p is the number of data points and d is
%the dimension of the data.  Returns the log likelihood and the fitted
%id's.  Assumes an identity prior on sigma for the variance of the mixture
%components and a flat prior on the means of the mixture components.

if(nargin<3)
    w=ones(size(id));
end;

x=y;
tid=id;
if(isnumeric(id))
    x=y(~isnan(id),:);
    tid=id(~isnan(id));
end;
alpha=.001;
uid=unique(tid);
n=length(uid);
[p d]=size(y);

mu=zeros(n,d);
sigma=zeros(n,d^2);

for(i=1:n)
    if(isnumeric(id)) kp=find(tid==uid(i) & w~=0);
    else kp=find(strcmp(tid,uid(i)) & w~=0);
    end;
    mu(i,:)=mean(x(kp,:));
    z=x(kp,:)-repmat(mu(i,:),length(kp),1);
    sig=(z'*z + alpha*eye(d))/(length(kp)+alpha);
    sigma(i,:)=sig(:);
end;

pid=id;
lp=zeros(p,n);
sig=zeros(d,d);
for(i=1:n)
    sig(:)=sigma(i,:);
    lp(:,i)=logmvnpdf(y',mu(i,:)',sig);
end;
ll=0;
for(i=1:n)
    if(isnumeric(id)) ll=ll+sum(lp(id==uid(i),i));
    else ll=ll+sum(lp(strcmp(id,uid(i)),i));
    end;
end;
lp=exp(lp-repmat(max(lp,[],2),1,n));
lp=lp./repmat(sum(lp,2),1,n);

