function [ res ] = ln1F1( a,b,z )
%Laplace approximation to the confluent hypergeometric function 1F1(a,b,z).
%z is allowed to be the diagonal elements of a matrix.  For ... a=1/2, b=n/2;

[n m]=size(z);
if(m>1 & n==1)
    z=z';
    n=m;
end;
if(m>1 & n>1)
    if(m==n)
        z=diag(z);
    else
        'z must be a diagonal matrix or vector with the diagonal elements of a diagonal matrix.'
        return;
    end;
end;

y=2*a./(b-z+sqrt((z-b).^2+4*a*z));

lnR=0;
for(i=1:n)
    for(j=i:n)
        lnR=lnR+log((1-y(i))*(1-y(j))/(b-a)+y(i)*y(j)/a);
    end;
end;
res=(b*n-n*(n+1)/4)*log(b)-.5*lnR+sum(a*log(y/a)+(b-a)*log((1-y)/(b-a)))+z'*y;

% y=2*a/(b-z+sqrt((z-b)^2+4*a*z));
% r11=y^2/a+(1-y)^2/(b-a);
% res=b^(b-1/2)*r11^(-1/2)*(y/a)^a*((1-y)/(b-a))^(b-a)*exp(z*y);

end
