function [ area ] = circIntArea( d,R,r )
%CIRCINTAREA Computes the area of intersection of two circles that are
%distance d apart and have radii R and r.

if(d>R+r)
    area=0;
elseif (d<abs(R-r))
    area=min(3.1415*r^2,3.1415*R^2);
else
    area=r^2*acos((d^2+r^2-R^2)/(2*d*r))+R^2*acos((d^2+R^2-r^2)/(2*d*R))-.5*sqrt((-d+r+R)*(d+r-R)*(d-r+R)*(d+r+R));
end;