function [bestq] = maxDiscrim( scr, time, died )
%MAXDISCRIM Summary of this function goes here
%   Detailed explanation goes here
time(time==0)=.01;
kp=find(time>0 & died>=0);
time=time(kp);
died=died(kp);
scr=scr(kp);

fontsize=16;

osr=sort(scr);

minp=1;
bestq=1/length(scr);
ps=zeros(length(scr),1);
for(i=floor(.2*length(scr)):floor(.8*length(scr)))
    [b,logl,fred,stats]=coxphfit(scr>osr(i),time,'censoring',1-died);
    ps(i)=stats.p;
    if(stats.p<minp)
        minp=stats.p;
        bestq=i/length(scr);
    end;
end;

kmgroup(time, died, scr>quantile(scr,bestq),[bestq*100])
set(gca,'fontsize',fontsize);
xlabel('Years','fontsize',fontsize);
ylabel('Survival','fontsize',fontsize);
title('');
legend('Low Signature','High Signature','location','southwest')
text(1,.4,['p=' num2str(minp)],'fontsize',fontsize);
bestp=minp;
