function [ res ] = lnAcgPdf( l,phi )
%ACGPDF density of the angular central gaussian with parameter matrix
%lambda at l.

[p n]=size(l);
ldet=sum(log(eig(phi)));
l=l./repmat(sqrt(sum(l.^2,2)),1,n);
a=log(2)+n/2*log(pi)-gammaln(n/2);
res=zeros(p,1)-a+ldet/2;
for(i=1:p)
    res(i)= - n/2*log(l(i,:)*phi*l(i,:)');
end;


end

